/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.dml.operators.ListVariable;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public class SimpleListVariable
extends ListVariable {
    private static final Operation[] emptyOps = new Operation[0];

    public SimpleListVariable(SourceRange sourceRange, String identifier) {
        super(sourceRange, identifier, emptyOps);
        assert (identifier != null);
    }

    @Override
    public Element execute(Context context) {
        Element result = context.getLocalVariable(this.identifier);
        if (result == null) {
            if (context.isCompileTimeContext()) {
                throw EvaluationException.create(this.sourceRange, "MSG_INVALID_IN_COMPILE_TIME_CONTEXT", this.getClass().getSimpleName());
            }
            if (context.getGlobalVariable(this.identifier) != null) {
                throw EvaluationException.create(this.sourceRange, "MSG_CANNOT_MODIFY_GLOBAL_VARIABLE_FROM_DML", this.identifier);
            }
            result = new ListResource();
            context.setLocalVariable(this.identifier, result);
        } else if (result instanceof Undef || result instanceof Null) {
            result = new ListResource();
            context.setLocalVariable(this.identifier, result);
        } else if (result.isProtected()) {
            result = result.writableCopy();
            context.setLocalVariable(this.identifier, result);
        }
        if (!(result instanceof ListResource)) {
            throw EvaluationException.create(this.sourceRange, "MSG_REFERENCED_VARIABLE_NOT_LIST", result.getTypeAsString());
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.identifier + "," + this.ops.length + ")";
    }
}

