/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.dml.operators.SetValue;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Term;

public class SetSelf
extends SetValue {
    public SetSelf(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super(sourceRange, "SELF", operations);
        if (operations.length == 0) {
            throw SyntaxException.create(sourceRange, "MSG_ILLEGAL_SELF_REF", new Object[0]);
        }
    }

    @Override
    public void checkInvalidSelfContext() throws SyntaxException {
        throw SyntaxException.create(this.sourceRange, "MSG_INVALID_SELF_REF_IN_INCLUDE", new Object[0]);
    }

    @Override
    public Element execute(Context context) {
        throw CompilerError.create("MSG_INVALID_EXECUTE_METHOD_CALLED", "SetSelf");
    }

    @Override
    public Element execute(Context context, Element result) {
        if (context.isCompileTimeContext()) {
            throw EvaluationException.create(this.sourceRange, "MSG_INVALID_IN_COMPILE_TIME_CONTEXT", this.getClass().getSimpleName());
        }
        Term[] terms = null;
        try {
            terms = this.calculateTerms(context);
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.sourceRange, context);
        }
        Element dupResult = result;
        if (result != null) {
            dupResult = result.duplicate();
        }
        if (context.isSelfFinal()) {
            EvaluationException ee = EvaluationException.create("MSG_CANNOT_MODIFY_SELF", new Object[0]);
            throw ee.addExceptionInfo(this.sourceRange, context);
        }
        try {
            Element self = context.getSelf();
            if (self.isProtected()) {
                self = self.writableCopy();
                context.resetSelf(self);
            }
            if (self instanceof Undef) {
                Term term = terms[0];
                self = term.isKey() ? new HashResource() : new ListResource();
                context.resetSelf(self);
            }
            try {
                self.rput(terms, 0, result);
            }
            catch (InvalidTermException ite) {
                throw new EvaluationException(ite.formatVariableMessage("SELF", terms));
            }
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.sourceRange, context);
        }
        return dupResult;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.identifier + "," + this.ops.length + ")";
    }
}

