/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.operators.Variable;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Term;

public class NestedVariable
extends Variable {
    public NestedVariable(SourceRange sourceRange, String identifier, boolean lookupOnly, Operation ... operations) {
        super(sourceRange, identifier, lookupOnly, operations);
        assert (operations.length > 0);
    }

    @Override
    public Element execute(Context context) {
        Term[] terms = null;
        try {
            terms = this.calculateTerms(context);
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
        Element result = null;
        try {
            try {
                result = context.dereferenceVariable(this.identifier, this.lookupOnly, terms);
            }
            catch (InvalidTermException ite) {
                if (!this.lookupOnly) {
                    throw new EvaluationException(ite.formatVariableMessage(this.identifier, terms));
                }
                result = null;
            }
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.sourceRange, context);
        }
        if (result == null && !this.lookupOnly) {
            StringBuilder sb = new StringBuilder(this.identifier);
            if (terms != null) {
                for (Term t : terms) {
                    sb.append("[");
                    sb.append(t.toString());
                    sb.append("]");
                }
            }
            throw new EvaluationException(MessageUtils.format("MSG_UNDEFINED_VAR", sb.toString()), this.sourceRange, context);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.identifier + "," + this.ops.length + ")";
    }
}

