/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.dml.operators.ListVariable;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Term;

public class NestedListVariable
extends ListVariable {
    public NestedListVariable(SourceRange sourceRange, String identifier, Operation ... operations) {
        super(sourceRange, identifier, operations);
        assert (operations.length > 0);
    }

    @Override
    public Element execute(Context context) {
        Term[] terms = null;
        try {
            terms = this.calculateTerms(context);
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
        Element result = context.getLocalVariable(this.identifier);
        if (result == null) {
            if (context.isCompileTimeContext()) {
                throw EvaluationException.create(this.sourceRange, "MSG_INVALID_IN_COMPILE_TIME_CONTEXT", this.getClass().getSimpleName());
            }
            if (context.getGlobalVariable(this.identifier) != null) {
                throw EvaluationException.create(this.sourceRange, "MSG_CANNOT_MODIFY_GLOBAL_VARIABLE_FROM_DML", this.identifier);
            }
            result = new ListResource();
            context.setLocalVariable(this.identifier, result);
        } else if (result instanceof Undef || result instanceof Null) {
            result = new ListResource();
            context.setLocalVariable(this.identifier, result);
        } else if (result.isProtected()) {
            result = result.writableCopy();
            context.setLocalVariable(this.identifier, result);
        }
        try {
            result = result.rgetList(terms, 0);
        }
        catch (InvalidTermException e2) {
            throw new EvaluationException(e2.formatVariableMessage(this.identifier, terms));
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.identifier + "," + this.ops.length + ")";
    }
}

