/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class LogicalNot
extends AbstractOperation {
    private LogicalNot(SourceRange sourceRange, Operation ... operations) {
        super(sourceRange, operations);
        assert (operations.length == 1);
    }

    public static Operation newOperation(SourceRange sourceRange, Operation ... ops) throws SyntaxException {
        assert (ops.length == 1);
        Operation result = null;
        if (ops[0] instanceof Element) {
            try {
                BooleanProperty a = (BooleanProperty)ops[0];
                result = LogicalNot.execute(a);
            }
            catch (ClassCastException cce) {
                throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_NOT", new Object[0]), sourceRange);
            }
            catch (EvaluationException ee) {
                throw SyntaxException.create(sourceRange, ee);
            }
        } else {
            result = new LogicalNot(sourceRange, ops);
        }
        return result;
    }

    @Override
    public Element execute(Context context) {
        try {
            Element[] args = this.calculateArgs(context);
            BooleanProperty a = (BooleanProperty)args[0];
            return LogicalNot.execute(a);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_NOT", new Object[0]), this.sourceRange);
        }
    }

    public static Element execute(BooleanProperty a) {
        return BooleanProperty.getInstance(a.getValue() == false);
    }
}

