/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.NumberProperty;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class LogicalNE
extends AbstractOperation {
    private LogicalNE(SourceRange sourceRange, Operation ... operations) {
        super(sourceRange, operations);
        assert (operations.length == 2);
    }

    public static Operation newOperation(SourceRange sourceRange, Operation ... ops) throws SyntaxException {
        assert (ops.length == 2);
        Operation result = null;
        if (ops[0] instanceof Element && ops[1] instanceof Element) {
            try {
                Property a = (Property)ops[0];
                Property b = (Property)ops[1];
                result = LogicalNE.execute(sourceRange, a, b);
            }
            catch (ClassCastException cce) {
                throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_NE", new Object[0]), sourceRange);
            }
            catch (EvaluationException ee) {
                throw SyntaxException.create(sourceRange, ee);
            }
        } else {
            result = new LogicalNE(sourceRange, ops);
        }
        return result;
    }

    @Override
    public Element execute(Context context) {
        try {
            Element[] args = this.calculateArgs(context);
            Property a = (Property)args[0];
            Property b = (Property)args[1];
            return LogicalNE.execute(this.sourceRange, a, b);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_NE", new Object[0]), this.sourceRange);
        }
    }

    private static Element execute(SourceRange sourceRange, Property a, Property b) {
        BooleanProperty result = null;
        if (a instanceof NumberProperty && b instanceof NumberProperty) {
            double d2;
            double d1 = ((NumberProperty)a).doubleValue();
            result = BooleanProperty.getInstance(d1 != (d2 = ((NumberProperty)b).doubleValue()));
        } else if (a instanceof StringProperty && b instanceof StringProperty) {
            String s2;
            String s1 = (String)a.getValue();
            result = BooleanProperty.getInstance(!s1.equals(s2 = (String)b.getValue()));
        } else if (a instanceof BooleanProperty && b instanceof BooleanProperty) {
            Boolean b2;
            Boolean b1 = (Boolean)a.getValue();
            result = BooleanProperty.getInstance(!b1.equals(b2 = (Boolean)b.getValue()));
        } else {
            throw new EvaluationException(MessageUtils.format("MSG_MISMATCHED_ARGS_NE", new Object[0]), sourceRange);
        }
        return result;
    }
}

