/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class IfElse
extends AbstractOperation {
    private IfElse(SourceRange sourceRange, Operation ... operations) {
        super(sourceRange, operations);
        assert (operations.length == 2 || operations.length == 3);
    }

    public static Operation newOperation(SourceRange sourceRange, Operation ... ops) throws SyntaxException {
        assert (ops.length == 2 || ops.length == 3);
        Operation result = null;
        if (ops[0] instanceof Element) {
            try {
                BooleanProperty a = (BooleanProperty)ops[0];
                if (a.getValue().booleanValue()) {
                    result = ops[1];
                }
                if (ops.length == 3) {
                    result = ops[2];
                }
                result = Undef.VALUE;
            }
            catch (ClassCastException cce) {
                throw SyntaxException.create(sourceRange, "MSG_INVALID_IF_ELSE_TEST", new Object[0]);
            }
        } else {
            result = new IfElse(sourceRange, ops);
        }
        return result;
    }

    @Override
    public Element execute(Context context) {
        assert (this.ops.length == 2 || this.ops.length == 3);
        boolean condition = false;
        try {
            condition = ((BooleanProperty)this.ops[0].execute(context)).getValue();
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_IF_ELSE_TEST", new Object[0]), this.sourceRange);
        }
        Operation op = null;
        op = condition ? this.ops[1] : (this.ops.length > 2 ? this.ops[2] : Undef.VALUE);
        return op.execute(context);
    }
}

