/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import java.util.ConcurrentModificationException;
import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.dml.operators.SetValue;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class Foreach
extends AbstractOperation {
    public Foreach(SourceRange sourceRange, Operation ... ops) {
        super(sourceRange, ops);
        assert (ops.length == 4);
        assert (ops[0] instanceof SetValue && ops[1] instanceof SetValue);
    }

    @Override
    public Element execute(Context context) {
        SetValue keyVariable = (SetValue)this.ops[0];
        SetValue valueVariable = (SetValue)this.ops[1];
        Operation resourceDml = this.ops[2];
        Operation body = this.ops[3];
        Element result = Undef.VALUE;
        Resource resource2 = null;
        try {
            resource2 = (Resource)resourceDml.execute(context);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_FOREACH_RESOURCE", new Object[0]), this.sourceRange);
        }
        keyVariable.execute(context, Undef.VALUE);
        valueVariable.execute(context, Undef.VALUE);
        try {
            for (Resource.Entry entry : resource2) {
                keyVariable.execute(context, (Element)entry.getKey());
                valueVariable.execute(context, Undef.VALUE);
                valueVariable.execute(context, (Element)entry.getValue());
                result = body.execute(context);
            }
        }
        catch (ConcurrentModificationException cme) {
            throw new EvaluationException(MessageUtils.format("MSG_CONCURRENT_MODIFICATION", new Object[0]), this.sourceRange);
        }
        return result;
    }
}

