/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class BitIOR
extends AbstractOperation {
    private BitIOR(SourceRange sourceRange, Operation ... operations) {
        super(sourceRange, operations);
        assert (operations.length == 2);
    }

    public static Operation newOperation(SourceRange sourceRange, Operation ... ops) throws SyntaxException {
        assert (ops.length == 2);
        Operation result = null;
        if (ops[0] instanceof Element && ops[1] instanceof Element) {
            try {
                LongProperty a = (LongProperty)ops[0];
                LongProperty b = (LongProperty)ops[1];
                result = BitIOR.execute(a, b);
            }
            catch (ClassCastException cce) {
                throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_BITIOR", new Object[0]), sourceRange);
            }
            catch (EvaluationException ee) {
                throw SyntaxException.create(sourceRange, ee);
            }
        } else {
            result = new BitIOR(sourceRange, ops);
        }
        return result;
    }

    @Override
    public Element execute(Context context) {
        try {
            Element[] args = this.calculateArgs(context);
            LongProperty a = (LongProperty)args[0];
            LongProperty b = (LongProperty)args[1];
            return BitIOR.execute(a, b);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_BITIOR", new Object[0]), this.sourceRange);
        }
    }

    private static Element execute(LongProperty a, LongProperty b) {
        long v1 = a.getValue();
        long v2 = b.getValue();
        return LongProperty.getInstance(v1 | v2);
    }
}

