/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.functions.Exists;
import org.quattor.pan.dml.operators.Variable;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class VariableExists
extends Exists {
    private VariableExists(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super(sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_ARG_REQ", "exists");
        }
        assert (operations.length == 1);
        if (!(operations[0] instanceof Variable)) {
            throw CompilerError.create("MSG_INVALID_ARG_IN_CONSTRUCTOR", new Object[0]);
        }
        Variable var = (Variable)operations[0];
        Variable nvar = Variable.getInstance(var, true);
        operations[0] = nvar;
        return new VariableExists(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        this.throwExceptionIfCompileTimeContext(context);
        assert (this.ops[0] instanceof Variable);
        try {
            Element result = this.ops[0].execute(context);
            return result == null ? BooleanProperty.FALSE : BooleanProperty.TRUE;
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
    }
}

