/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Path;

public final class Value
extends BuiltInFunction {
    private Value(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("value", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_STRING_ARG_REQ", "value");
        }
        return new Value(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        assert (this.ops.length == 1);
        this.throwExceptionIfCompileTimeContext(context);
        Element result = null;
        Path p = null;
        try {
            String s = ((StringProperty)this.ops[0].execute(context)).getValue();
            try {
                p = new Path(s);
                result = context.getElement(p);
            }
            catch (SyntaxException se) {
                throw new EvaluationException(se.getSimpleMessage(), this.sourceRange, context);
            }
        }
        catch (ClassCastException cce) {
            Element element = this.ops[0].execute(context);
            throw new EvaluationException("value() requires one string argument; " + element.getTypeAsString() + " found", this.getSourceRange(), context);
        }
        if (result != null) {
            return result.duplicate();
        }
        throw new EvaluationException("referenced path (" + p + ") doesn't exist", this.getSourceRange(), context);
    }
}

