/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.DoubleProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class ToLongRadix
extends BuiltInFunction {
    private ToLongRadix(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("to_long", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 2) {
            throw SyntaxException.create(sourceRange, "MSG_TWO_ARGS_REQ", "radix with to_long");
        }
        return new ToLongRadix(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        assert (this.ops.length == 2);
        Element result = this.ops[0].execute(context);
        Element radixProperty = this.ops[1].execute(context);
        int radix = this.getRadix(context, radixProperty);
        try {
            Element value = null;
            Property property = (Property)result;
            if (property instanceof BooleanProperty) {
                long x = ((BooleanProperty)property).getValue() != false ? 1L : 0L;
                value = LongProperty.getInstance(x);
            } else if (property instanceof DoubleProperty) {
                double x = ((DoubleProperty)property).getValue();
                value = LongProperty.getInstance(Math.round(x));
            } else if (property instanceof StringProperty) {
                String x = ((StringProperty)property).getValue();
                try {
                    value = LongProperty.getInstance(Long.parseLong(x, radix));
                }
                catch (NumberFormatException nfe) {
                    throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_STRING_FOR_LONG", x);
                }
            } else if (property instanceof LongProperty) {
                value = result;
            } else {
                throw CompilerError.create("MSG_UNKNOWN_PROPERTY_TYPE", property.getClass());
            }
            return value;
        }
        catch (ClassCastException cce) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_ARG_NOT_PROPERTY", result.getTypeAsString());
        }
    }

    private int getRadix(Context context, Element e2) {
        try {
            long radix = 0L;
            Property property = (Property)e2;
            if (property instanceof LongProperty) {
                radix = ((LongProperty)e2).getValue();
                if (radix < 2L || radix > 36L) {
                    throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_RADIX", radix, 2, 36);
                }
            } else {
                throw EvaluationException.create("MSG_INVALID_RADIX_TYPE", property.getClass());
            }
            return (int)radix;
        }
        catch (ClassCastException cce) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_ARG_NOT_PROPERTY", e2.getTypeAsString());
        }
    }
}

