/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.DoubleProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class ToDouble
extends BuiltInFunction {
    private ToDouble(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("to_double", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_ARG_REQ", "to_double");
        }
        return new ToDouble(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        assert (this.ops.length == 1);
        Element result = this.ops[0].execute(context);
        try {
            Element value = null;
            Property property = (Property)result;
            if (property instanceof BooleanProperty) {
                double x = ((BooleanProperty)property).getValue() != false ? 1.0 : 0.0;
                value = DoubleProperty.getInstance(x);
            } else if (property instanceof LongProperty) {
                double x = ((LongProperty)property).getValue().doubleValue();
                value = DoubleProperty.getInstance(x);
            } else if (property instanceof StringProperty) {
                String x = ((StringProperty)property).getValue();
                try {
                    value = DoubleProperty.getInstance(Double.parseDouble(x));
                }
                catch (NumberFormatException nfe) {
                    throw new EvaluationException("string cannot be converted to double: " + x, this.sourceRange, context);
                }
            } else if (property instanceof DoubleProperty) {
                value = result;
            } else {
                throw CompilerError.create("MSG_UNKNOWN_PROPERTY_TYPE", property.getClass());
            }
            return value;
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("to_double argument is not a property: " + result.getTypeAsString(), this.sourceRange, context);
        }
    }
}

