/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.IllegalFormatException;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Substitute
extends BuiltInFunction {
    private Substitute(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("substitute", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length == 1 || operations.length == 2) {
            return new Substitute(sourceRange, operations);
        }
        throw SyntaxException.create(sourceRange, "MSG_ONE_OR_TWO_ARGS_REQ", "substitute");
    }

    @Override
    public Element execute(Context context) {
        assert (this.ops.length == 1 || this.ops.length == 2);
        Element[] args = this.calculateArgs(context);
        String template2 = null;
        try {
            template2 = ((StringProperty)args[0]).getValue();
        }
        catch (ClassCastException cce) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_FIRST_ARG_SUBSTITUTE", new Object[0]);
        }
        HashResource valueMap = null;
        if (this.ops.length == 2) {
            try {
                valueMap = (HashResource)args[1];
            }
            catch (ClassCastException cce) {
                throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_SECOND_ARG_SUBSTITUTE", new Object[0]);
            }
        }
        StringProperty result = null;
        try {
            Resolver resolver = new Resolver(valueMap, context);
            StrSubstitutor sub = new StrSubstitutor(resolver);
            result = StringProperty.getInstance(sub.replace(template2));
        }
        catch (IllegalFormatException ife) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_ILLEGAL_FORMAT", ife.getLocalizedMessage());
        }
        assert (result != null);
        return result;
    }

    private class Resolver
    extends StrLookup<String> {
        private final HashResource valueMap;
        private final Context context;

        public Resolver(HashResource valueMap, Context context) {
            this.valueMap = valueMap;
            this.context = context;
        }

        @Override
        public String lookup(String key2) {
            try {
                if (this.valueMap != null) {
                    StringProperty k = StringProperty.getInstance(key2);
                    return this.valueMap.get(k).toString();
                }
                return this.context.getVariable(key2).toString();
            }
            catch (InvalidTermException e2) {
                throw EvaluationException.create(Substitute.this.sourceRange, this.context, "MSG_INVALID_SUBSTITUTE_VARIABLE", key2);
            }
            catch (NullPointerException e3) {
                throw EvaluationException.create(Substitute.this.sourceRange, this.context, "MSG_SUBSTITUTE_VARIABLE_UNDEFINED", key2);
            }
        }
    }
}

