/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.regex.Matcher;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.AbstractStaticMatcher;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class StaticMatches
extends AbstractStaticMatcher {
    private StaticMatches(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super(sourceRange, "matches", operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        return new StaticMatches(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        assert (this.ops.length == 1);
        Element e2 = this.ops[0].execute(context);
        try {
            String s = ((StringProperty)e2).getValue();
            Matcher matcher = this.pattern.matcher(s);
            ListResource list = new ListResource();
            if (matcher.find()) {
                int i;
                int lastGroup = 0;
                for (i = 0; i <= matcher.groupCount(); ++i) {
                    if (matcher.group(i) == null) continue;
                    lastGroup = i;
                }
                for (i = 0; i <= lastGroup; ++i) {
                    String group = matcher.group(i);
                    if (group == null) {
                        group = "";
                    }
                    list.put(i, (Element)StringProperty.getInstance(group));
                }
            }
            return list;
        }
        catch (ClassCastException cce) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_ALL_STRING_ARGS_REQ", this.name, e2.getTypeAsString());
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.sourceRange, context);
        }
    }
}

