/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.PersistentElement;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Splice
extends BuiltInFunction {
    private Splice(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("splice", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length < 3 || operations.length > 4) {
            throw SyntaxException.create(sourceRange, "MSG_3_OR_4_ARGS", "splice");
        }
        return new Splice(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        Element[] args = this.calculateArgs(context);
        assert (this.ops.length == 3 || this.ops.length == 4);
        PersistentElement result = null;
        int start = 0;
        try {
            long slong = ((LongProperty)args[1]).getValue();
            if (slong > Integer.MAX_VALUE || slong < Integer.MIN_VALUE) {
                throw new EvaluationException("second argument to splice() cannot be converted to int: " + slong, this.getSourceRange(), context);
            }
            start = (int)slong;
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("second argument to splice() must be a long", this.getSourceRange(), context);
        }
        int length = 0;
        try {
            long slong = ((LongProperty)args[2]).getValue();
            if (slong > Integer.MAX_VALUE || slong < Integer.MIN_VALUE) {
                throw new EvaluationException("third argument to splice() cannot be converted to int: " + slong, this.getSourceRange(), context);
            }
            length = (int)slong;
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("third argument to splice() must be a long", this.getSourceRange(), context);
        }
        if (args[0] instanceof StringProperty) {
            int end;
            String middle;
            if (args.length == 4 && !(args[3] instanceof StringProperty)) {
                throw new EvaluationException("fourth argument of splice() must be of the same type as the first", this.getSourceRange(), context);
            }
            String s = ((StringProperty)args[0]).getValue();
            String string2 = middle = args.length == 4 ? ((StringProperty)args[3]).getValue() : "";
            if (start < 0) {
                start = s.length() + start;
            }
            int n = end = length >= 0 ? start + length : s.length() + length;
            if (start < 0) {
                throw new EvaluationException("start index in splice() is before beginning of string", this.getSourceRange(), context);
            }
            if (start > s.length()) {
                throw new EvaluationException("start index in splice() is after end of string", this.getSourceRange(), context);
            }
            if (end < 0) {
                throw new EvaluationException("end index in splice() is before beginning of string", this.getSourceRange(), context);
            }
            if (end > s.length()) {
                throw new EvaluationException("end index in splice() is after end of string", this.getSourceRange(), context);
            }
            if (end < start) {
                throw new EvaluationException("end index is before the start index", this.getSourceRange(), context);
            }
            String r = s.substring(0, start) + middle + s.substring(end);
            result = StringProperty.getInstance(r);
        } else if (args[0] instanceof ListResource) {
            long i;
            ListResource rlist;
            int end;
            ListResource mlist;
            if (args.length == 4 && !(args[3] instanceof ListResource)) {
                throw new EvaluationException("fourth argument of splice() must be of the same type as the first", this.getSourceRange(), context);
            }
            ListResource slist = (ListResource)args[0];
            ListResource listResource = mlist = args.length == 4 ? (ListResource)args[3] : new ListResource();
            if (start < 0) {
                start = slist.size() + start;
            }
            int n = end = length >= 0 ? start + length : slist.size() + length;
            if (start < 0) {
                throw new EvaluationException("start index in splice() is before beginning of list", this.getSourceRange(), context);
            }
            if (start > slist.size()) {
                throw new EvaluationException("start index in splice() is after end of list", this.getSourceRange(), context);
            }
            if (end < 0) {
                throw new EvaluationException("end index in splice() is before beginning of list", this.getSourceRange(), context);
            }
            if (end > slist.size()) {
                throw new EvaluationException("end index in splice() is after end of list", this.getSourceRange(), context);
            }
            if (end < start) {
                throw new EvaluationException("end index is before the start index", this.getSourceRange(), context);
            }
            result = rlist = new ListResource();
            int index2 = 0;
            for (Resource.Entry entry : slist) {
                i = ((LongProperty)entry.getKey()).getValue();
                if (i >= (long)start) continue;
                rlist.put(index2++, (Element)entry.getValue());
            }
            for (Resource.Entry entry : mlist) {
                rlist.put(index2++, (Element)entry.getValue());
            }
            for (Resource.Entry entry : slist) {
                i = ((LongProperty)entry.getKey()).getValue();
                if (i < (long)end) continue;
                rlist.put(index2++, (Element)entry.getValue());
            }
        } else {
            throw new EvaluationException("first argument of splice() must be a string or list", this.getSourceRange(), context);
        }
        return result;
    }
}

