/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Path;

public final class PathExists
extends BuiltInFunction {
    protected PathExists(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("path_exists", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_ARG_REQ", "path_exists");
        }
        assert (operations.length == 1);
        Operation op = operations[0];
        if (op instanceof Element) {
            try {
                String s = ((StringProperty)op).getValue();
                Path path2 = new Path(s);
                if (path2.isRelative()) {
                    throw SyntaxException.create(sourceRange, "MSG_RELATIVE_PATH_NOT_ALLOWED", new Object[0]);
                }
            }
            catch (ClassCastException cce) {
                throw SyntaxException.create(sourceRange, "MSG_ONE_STRING_ARG_REQ", new Object[0]);
            }
        }
        return new PathExists(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        this.throwExceptionIfCompileTimeContext(context);
        Element result = this.ops[0].execute(context);
        boolean exists = false;
        try {
            String s = ((StringProperty)result).getValue();
            Path path2 = new Path(s);
            if (path2.isRelative()) {
                throw EvaluationException.create(this.sourceRange, context, "MSG_RELATIVE_PATH_NOT_ALLOWED", new Object[0]);
            }
            exists = context.getElement(path2, false) != null;
            return exists ? BooleanProperty.TRUE : BooleanProperty.FALSE;
        }
        catch (SyntaxException se) {
            throw new EvaluationException(se.getMessage(), this.sourceRange, context);
        }
        catch (ClassCastException cce) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_ONE_STRING_ARG_REQ", new Object[0]);
        }
    }
}

