/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.NoSuchElementException;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.dml.operators.SetValue;
import org.quattor.pan.dml.operators.Variable;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Next
extends BuiltInFunction {
    private Next(SourceRange sourceRange, Operation ... operations) {
        super("next", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 3) {
            throw SyntaxException.create(sourceRange, "MSG_3_ARGS_REQ", "next");
        }
        if (operations[1] instanceof Variable) {
            operations[1] = SetValue.getInstance((Variable)operations[1]);
        } else if (!(operations[1] instanceof Undef)) {
            throw SyntaxException.create(sourceRange, "MSG_VARIABLE_REF_OR_UNDEF", "next");
        }
        if (operations[2] instanceof Variable) {
            operations[2] = SetValue.getInstance((Variable)operations[2]);
        } else if (!(operations[2] instanceof Undef)) {
            throw SyntaxException.create(sourceRange, "MSG_VARIABLE_REF_OR_UNDEF", "next");
        }
        return new Next(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        Resource resource2 = null;
        try {
            resource2 = (Resource)this.ops[0].execute(context);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("first argument to next() must be a resource", this.getSourceRange(), context);
        }
        Resource.Iterator iterator = context.getIterator(resource2);
        if (iterator == null) {
            throw new EvaluationException("no valid iterator found for resource", this.getSourceRange(), context);
        }
        if (iterator.hasNext()) {
            try {
                Resource.Entry entry = (Resource.Entry)iterator.next();
                if (this.ops[1] instanceof SetValue) {
                    ((SetValue)this.ops[1]).execute(context, (Element)entry.getKey());
                }
                if (this.ops[2] instanceof SetValue) {
                    ((SetValue)this.ops[2]).execute(context, Undef.VALUE);
                    ((SetValue)this.ops[2]).execute(context, (Element)entry.getValue());
                }
            }
            catch (NoSuchElementException nsee) {
                throw new EvaluationException("illegal iteration", this.getSourceRange(), context);
            }
            return BooleanProperty.TRUE;
        }
        return BooleanProperty.FALSE;
    }
}

