/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Term;
import org.quattor.pan.utils.TermFactory;

public final class Merge
extends BuiltInFunction {
    private Merge(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("merge", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length == 0) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_OR_MORE_ARG_REQ", "merge");
        }
        return new Merge(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        Element[] args = this.calculateArgs(context);
        assert (args.length > 0);
        Resource result = null;
        if (args[0] instanceof HashResource) {
            try {
                HashResource dictResult;
                result = dictResult = new HashResource();
                for (Element element : args) {
                    HashResource dict = (HashResource)element;
                    for (Term term : dict.keySet()) {
                        try {
                            if (dictResult.put(term, dict.get(term)) == null) continue;
                            throw new EvaluationException("two (or more) children have the same name in merge(): " + term, this.getSourceRange(), context);
                        }
                        catch (InvalidTermException ite) {
                            throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
                        }
                    }
                }
            }
            catch (ClassCastException cce) {
                throw new EvaluationException("merge() arguments must be all lists or dicts", this.getSourceRange(), context);
            }
        } else if (args[0] instanceof ListResource) {
            try {
                ListResource listResult = new ListResource();
                result = listResult;
                int index2 = 0;
                for (Element element : args) {
                    ListResource list = (ListResource)element;
                    for (int i = 0; i < list.size(); ++i) {
                        Term term = TermFactory.create(i);
                        try {
                            listResult.put(index2++, list.get(term));
                            continue;
                        }
                        catch (InvalidTermException ite) {
                            throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
                        }
                    }
                }
            }
            catch (ClassCastException cce) {
                throw new EvaluationException("merge() arguments must be all lists or dicts", this.getSourceRange(), context);
            }
        } else {
            throw new EvaluationException("merge() arguments must be all lists or dicts", this.getSourceRange(), context);
        }
        return result;
    }
}

