/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class LongToIp
extends BuiltInFunction {
    private LongToIp(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("long_to_ip4", sourceRange, operations);
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_ARG_REQ", this.name);
        }
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        return new LongToIp(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        long nip;
        assert (this.ops.length == 1);
        Element[] args = this.calculateArgs(context);
        String[] ip = new String[4];
        try {
            nip = ((LongProperty)args[0]).getValue();
        }
        catch (ClassCastException cce) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_TYPE_LONG_TO_IP", new Object[0]);
        }
        if (nip > 0xFFFFFFFFL || nip < 0L) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_RANGE_LONG_TO_IP", new Object[0]);
        }
        int i = 3;
        while (i >= 0) {
            ip[i] = Long.toString(nip & 0xFFL);
            --i;
            nip >>= 8;
        }
        StringProperty result = StringProperty.getInstance(String.format("%s.%s.%s.%s", ip[0], ip[1], ip[2], ip[3]));
        assert (result != null);
        return result;
    }
}

