/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Length
extends BuiltInFunction {
    private Length(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("length", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_ARG_REQ", "length");
        }
        return new Length(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        assert (this.ops.length == 1);
        Element result = this.ops[0].execute(context);
        int length = 0;
        if (result instanceof StringProperty) {
            length = ((StringProperty)result).getValue().length();
        } else if (result instanceof Resource) {
            length = ((Resource)result).size();
        } else if (result instanceof Undef) {
            length = 0;
        } else {
            if (result != null) {
                throw new EvaluationException("argument to length must be undef, string, or resource; element of type " + result.getTypeAsString() + " is not valid", this.getSourceRange(), context);
            }
            throw CompilerError.create("MSG_NULL_RESULT_FROM_OPERATION", new Object[0]);
        }
        return LongProperty.getInstance(length);
    }
}

