/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.ArrayList;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Join
extends BuiltInFunction {
    protected Join(SourceRange sourceRange, Operation ... operations) {
        super("join", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length < 2) {
            throw SyntaxException.create(sourceRange, "MSG_TWO_OR_MORE_ARG_REQ", "join");
        }
        if (operations[0] instanceof Null || operations[1] instanceof Null) {
            throw SyntaxException.create(sourceRange, "MSG_VALUE_CANNOT_BE_NULL", "join");
        }
        if (operations.length == 2 && operations[1] instanceof Element && !(operations[1] instanceof ListResource)) {
            throw SyntaxException.create(sourceRange, "MSG_SECOND_ARG_LIST_OR_VARIABLE_REF", "join");
        }
        return new Join(sourceRange, operations);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Element execute(Context context) throws EvaluationException {
        assert (this.ops.length != 1);
        String delimeter = null;
        try {
            delimeter = ((StringProperty)this.ops[0].execute(context)).getValue();
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("first argument in join() must be a string", this.getSourceRange(), context);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.ops.length == 2) {
            Element list = this.ops[1].execute(context);
            if (!(list instanceof ListResource)) throw new EvaluationException("join() only accepts strings or a list of strings as input arguments", this.getSourceRange(), context);
            Resource.Iterator it = ((ListResource)list).iterator();
            while (it.hasNext()) {
                Element e2 = (Element)((Resource.Entry)it.next()).getValue();
                if (e2 instanceof Resource) {
                    throw new EvaluationException("join() doesn't accept nested elements in the passed list", this.getSourceRange(), context);
                }
                if (!(e2 instanceof StringProperty)) {
                    throw new EvaluationException("join() only accepts strings as elements in the list", this.getSourceRange(), context);
                }
                result.add(((StringProperty)e2).getValue());
            }
            return StringProperty.getInstance(String.join((CharSequence)delimeter, result));
        } else {
            int length = this.ops.length;
            for (int i = 1; i < length; ++i) {
                Element e3 = this.ops[i].execute(context);
                if (e3 instanceof ListResource) {
                    throw new EvaluationException("join() only accepts a single list as an argument or all the arguments individually", this.getSourceRange(), context);
                }
                if (!(e3 instanceof StringProperty)) {
                    throw new EvaluationException("join() only accepts strings or a list of strings as input arguments", this.getSourceRange(), context);
                }
                result.add(((StringProperty)e3).getValue());
            }
        }
        return StringProperty.getInstance(String.join((CharSequence)delimeter, result));
    }
}

