/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.functions.IsOfType;
import org.quattor.pan.dml.operators.Variable;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class IsValueOfType
extends IsOfType {
    private IsValueOfType(SourceRange sourceRange, Class<? extends Element> type2, String name2, Operation ... operations) throws SyntaxException {
        super(name2, sourceRange, type2, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Class<? extends Element> type2, String name2, Operation ... operations) throws SyntaxException {
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_ARG_REQ", name2);
        }
        assert (operations.length == 1);
        if (operations[0] instanceof Variable) {
            throw CompilerError.create("MSG_INVALID_ARG_IN_CONSTRUCTOR", new Object[0]);
        }
        return new IsValueOfType(sourceRange, type2, name2, operations);
    }

    @Override
    public Element execute(Context context) {
        assert (this.ops.length == 1);
        Element result = this.ops[0].execute(context);
        return this.type.isAssignableFrom(result.getClass()) ? BooleanProperty.TRUE : BooleanProperty.FALSE;
    }
}

