/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class IpToLong
extends BuiltInFunction {
    private static final Pattern IP4_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)(?:/(\\d+))?$");
    private static final int MAX_BITS_BITMASK = 32;

    private IpToLong(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("ip4_to_long", sourceRange, operations);
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_ARG_REQ", this.name);
        }
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        return new IpToLong(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        String ip;
        assert (this.ops.length == 1);
        long mask = -1L;
        Element[] args = this.calculateArgs(context);
        try {
            ip = ((StringProperty)args[0]).getValue();
        }
        catch (ClassCastException cce) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_TYPE_IP_TO_LONG", new Object[0]);
        }
        Matcher m = IP4_PATTERN.matcher(ip);
        if (!m.find()) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_IP4_FORMAT", new Object[0]);
        }
        long nip = 0L;
        int i = 1;
        while (i <= 4) {
            long j = Long.parseLong(m.group(i));
            if (j > 255L) {
                throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_IP4_FORMAT", new Object[0]);
            }
            nip |= j;
            ++i;
            nip <<= 8;
        }
        nip >>= 8;
        try {
            mask = 0xFFFFFFFFL;
            i = Integer.parseInt(m.group(5));
            if (i < 0 || i > 32) {
                throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_IP4_BITMASK", new Object[0]);
            }
            i = 32 - i;
            mask = mask >> i << i;
        }
        catch (NumberFormatException j) {
            // empty catch block
        }
        ListResource result = new ListResource();
        result.append(LongProperty.getInstance(nip));
        if (mask != -1L) {
            result.append(LongProperty.getInstance(mask));
        }
        assert (result != null);
        return result;
    }
}

