/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Index
extends BuiltInFunction {
    private Index(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("index", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length < 2 || operations.length > 3) {
            throw SyntaxException.create(sourceRange, "MSG_2_OR_3_ARGS", "index");
        }
        return new Index(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        assert (this.ops.length == 2 || this.ops.length == 3);
        Element[] args = this.calculateArgs(context);
        int fromIndex = 0;
        if (args.length == 3) {
            try {
                fromIndex = ((LongProperty)args[2]).getValue().intValue();
                if (fromIndex < 0) {
                    fromIndex = 0;
                }
            }
            catch (ClassCastException cce) {
                throw new EvaluationException("third argument of index() must be a long", this.getSourceRange(), context);
            }
        }
        if (args[0] instanceof StringProperty && args[1] instanceof StringProperty) {
            String str2 = ((StringProperty)args[0]).getValue();
            String target = ((StringProperty)args[1]).getValue();
            return LongProperty.getInstance(target.indexOf(str2, fromIndex));
        }
        if (args[1] instanceof ListResource) {
            Resource resource2 = (Resource)args[1];
            int count2 = 0;
            for (Resource.Entry entry : resource2) {
                if (count2 >= fromIndex) {
                    Property key2 = (Property)entry.getKey();
                    Element value = (Element)entry.getValue();
                    if (args[0].equals(value)) {
                        return key2;
                    }
                }
                ++count2;
            }
            return LongProperty.getInstance(-1L);
        }
        if (args[1] instanceof HashResource) {
            Resource resource3 = (Resource)args[1];
            int count3 = 0;
            for (Resource.Entry entry : resource3) {
                Property key3 = (Property)entry.getKey();
                Element value = (Element)entry.getValue();
                if (!args[0].equals(value)) continue;
                if (count3 < fromIndex) {
                    ++count3;
                    continue;
                }
                return key3;
            }
            return StringProperty.getInstance("");
        }
        throw new EvaluationException("invalid argument(s) in call to index()", this.getSourceRange(), context);
    }
}

