/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.HashSet;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Term;
import org.quattor.pan.utils.TermFactory;

public final class Hash
extends BuiltInFunction {
    private Hash(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("dict", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length % 2 != 0) {
            throw SyntaxException.create(sourceRange, "MSG_EVEN_NUMBER_OF_ARGS", new Object[0]);
        }
        try {
            HashSet<Term> keys2 = new HashSet<Term>();
            for (int i = 0; i < operations.length; i += 2) {
                if (!(operations[i] instanceof Element)) continue;
                Term key2 = Hash.createKey((Element)operations[i]);
                if (keys2.contains(key2)) {
                    throw EvaluationException.create("MSG_DUPLICATE_KEY", key2);
                }
                keys2.add(key2);
            }
        }
        catch (EvaluationException ee) {
            throw SyntaxException.create(sourceRange, ee);
        }
        return new Hash(sourceRange, operations);
    }

    private static HashResource createHashFromArgs(Element[] args) {
        assert (args.length % 2 == 0);
        HashResource result = new HashResource();
        for (int i = 0; i < args.length; i += 2) {
            Term t = null;
            try {
                t = Hash.createKey(args[i]);
                Element value = args[i + 1];
                Element old = result.put(t, value);
                if (old == null) continue;
                throw EvaluationException.create("MSG_DUPLICATE_KEY", t);
            }
            catch (InvalidTermException ite) {
                throw EvaluationException.create("MSG_INVALID_KEY_HASH", t);
            }
        }
        return result;
    }

    private static Term createKey(Element stringProperty) {
        Term result = null;
        try {
            StringProperty key2 = (StringProperty)stringProperty;
            result = TermFactory.create(key2);
        }
        catch (ClassCastException cce) {
            throw EvaluationException.create("MSG_INVALID_KEY_TYPE", stringProperty.getTypeAsString());
        }
        if (!result.isKey()) {
            throw EvaluationException.create("MSG_INVALID_KEY_HASH", stringProperty);
        }
        return result;
    }

    @Override
    public Element execute(Context context) {
        Element[] args = this.calculateArgs(context);
        assert (args.length % 2 == 0);
        try {
            return Hash.createHashFromArgs(args);
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.sourceRange, context);
        }
    }
}

