/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.logging.Level;
import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.ReturnValueException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.LocalVariableMap;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.FunctionDefinition;
import org.quattor.pan.utils.GlobalVariable;

public final class Function
extends AbstractOperation {
    private String name = null;

    public Function(SourceRange sourceRange, String name2, Operation ... operations) {
        super(sourceRange, operations);
        assert (name2 != null);
        this.name = name2;
    }

    @Override
    public Element execute(Context context) {
        FunctionDefinition fd = context.getFunction(this.name);
        if (fd == null) {
            throw new EvaluationException("undefined function: " + this.name, this.sourceRange, context);
        }
        int nargs = this.ops.length;
        ListResource argv = new ListResource();
        for (int i = 0; i < nargs; ++i) {
            argv.put(i, this.ops[i].execute(context));
        }
        LocalVariableMap oldLocalVariables = context.createLocalVariableMap(argv);
        GlobalVariable oldFunctionVariable = context.replaceGlobalVariable("FUNCTION", StringProperty.getInstance(this.name), true);
        String logMessage = "FUNCTION " + this.name;
        context.pushTemplate(fd.template, this.sourceRange, Level.CONFIG, logMessage);
        Element result = null;
        try {
            result = fd.dml.execute(context);
        }
        catch (ReturnValueException rve) {
            result = rve.getElement();
        }
        context.setGlobalVariable("FUNCTION", oldFunctionVariable);
        context.popTemplate(Level.CONFIG, logMessage);
        context.restoreLocalVariableMap(oldLocalVariables);
        return result;
    }

    @Override
    public String toString() {
        return this.name + "(" + this.ops.length + ")";
    }
}

