/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class FileExists
extends BuiltInFunction {
    private FileExists(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("file_exists", sourceRange, operations);
        String relativePath;
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_ARG_REQ", "file_exists");
        }
        if (operations[0] instanceof Element && (relativePath = FileExists.verifyRelativePath((Element)operations[0])) == null) {
            throw SyntaxException.create(sourceRange, "MSG_RELATIVE_FILE_REQ", "file_exists");
        }
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        return new FileExists(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        this.throwExceptionIfCompileTimeContext(context);
        Element[] args = this.calculateArgs(context);
        assert (args.length == 1);
        String relativeFileName = FileExists.verifyRelativePath(args[0]);
        if (relativeFileName == null) {
            throw EvaluationException.create(this.sourceRange, "MSG_RELATIVE_FILE_REQ", this.name);
        }
        SourceFile srcFile = context.lookupFile(relativeFileName);
        return BooleanProperty.getInstance(!srcFile.isAbsent());
    }

    private static String verifyRelativePath(Element element) {
        try {
            String name2 = ((StringProperty)element).getValue();
            if ("".equals(name2) || name2.startsWith("/")) {
                return null;
            }
            return name2;
        }
        catch (ClassCastException e2) {
            return null;
        }
    }
}

