/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.Formatter;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class ErrorMessage
extends Formatter {
    private ErrorMessage(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("error", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length == 0) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_OR_MORE_ARG_REQ", "error");
        }
        return new ErrorMessage(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        assert (this.ops.length >= 1);
        StringProperty sp = null;
        if (this.ops.length == 1) {
            Element result = this.ops[0].execute(context);
            try {
                sp = (StringProperty)result;
            }
            catch (ClassCastException cce) {
                throw EvaluationException.create(this.getSourceRange(), "MSG_USER_INITIATED_ERROR_WITHOUT_STRING", new Object[0]);
            }
        } else {
            sp = this.format(context);
        }
        throw EvaluationException.create(this.sourceRange, context, "MSG_USER_INITIATED_ERROR", context.getObjectName(), sp.getValue());
    }

    @Override
    public void checkRestrictedContext() throws SyntaxException {
        super.checkRestrictedContext();
        throw SyntaxException.create(this.sourceRange, "MSG_RESTRICTED_CONTEXT", this.name);
    }
}

