/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Deprecated
extends BuiltInFunction {
    private Deprecated(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("deprecated", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 2) {
            throw SyntaxException.create(sourceRange, "MSG_TWO_ARGS_REQ", "deprecated");
        }
        Operation op = operations[0];
        if (op instanceof Element) {
            if (op instanceof LongProperty) {
                Long value = ((LongProperty)op).getValue();
                if (value < 0L) {
                    throw SyntaxException.create(sourceRange, "MSG_INVALID_FIRST_ARG_DEPRECATED", new Object[0]);
                }
            } else {
                throw SyntaxException.create(sourceRange, "MSG_INVALID_FIRST_ARG_DEPRECATED", new Object[0]);
            }
        }
        if ((op = operations[1]) instanceof Element && !(op instanceof StringProperty)) {
            throw SyntaxException.create(sourceRange, "MSG_INVALID_SECOND_ARG_DEPRECATED", new Object[0]);
        }
        return new Deprecated(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        assert (this.ops.length == 2);
        Undef value = Undef.VALUE;
        if (!context.isCompileTimeContext()) {
            Element[] args = this.calculateArgs(context);
            if (!(args[0] instanceof LongProperty)) {
                throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_FIRST_ARG_DEPRECATED", new Object[0]);
            }
            if (!(args[1] instanceof StringProperty)) {
                throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_SECOND_ARG_DEPRECATED", new Object[0]);
            }
            Long level = ((LongProperty)args[0]).getValue();
            StringProperty msg = (StringProperty)args[1];
            if (level < 0L) {
                throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_FIRST_ARG_DEPRECATED", new Object[0]);
            }
            switch (context.getDeprecationWarnings()) {
                case ON: {
                    System.err.println(msg.getValue());
                    break;
                }
                case FATAL: {
                    throw EvaluationException.create(this.sourceRange, context, "MSG_FATAL_DEPRECATION_MSG", msg.getValue());
                }
            }
        }
        return value;
    }
}

