/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.Formatter;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Debug
extends Formatter {
    private Debug(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("debug", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length == 0) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_OR_MORE_ARG_REQ", "debug");
        }
        if (operations.length == 1 && operations[0] instanceof Element && !(operations[0] instanceof StringProperty)) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_STRING_ARG_REQ", "debug");
        }
        return new Debug(sourceRange, operations);
    }

    @Override
    public Element execute(Context context) {
        assert (this.ops.length >= 1);
        this.throwExceptionIfCompileTimeContext(context);
        Element result = null;
        result = this.ops.length == 1 ? this.ops[0].execute(context) : this.format(context);
        try {
            StringProperty sp = result;
            String objectName = context.getObjectName();
            String msg = String.format("[%s] %s", objectName, sp.getValue());
            System.err.println(msg);
        }
        catch (ClassCastException cce) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_ONE_STRING_ARG_REQ", this.name);
        }
        return result;
    }
}

