/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.SourceRange;

public abstract class AbstractMatcher
extends BuiltInFunction {
    protected AbstractMatcher(String name2, SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super(name2, sourceRange, operations);
        for (Operation op : operations) {
            if (!(op instanceof Element) || op instanceof StringProperty) continue;
            String badtype = ((Element)op).getTypeAsString();
            throw SyntaxException.create(sourceRange, "MSG_ALL_STRING_ARGS_REQ", name2, badtype);
        }
    }

    protected int convertMatchFlags(Element opts) {
        int flags = 0;
        String sopts = ((StringProperty)opts).getValue();
        block7: for (int i = 0; i < sopts.length(); ++i) {
            char c = sopts.charAt(i);
            switch (c) {
                case 'i': {
                    flags |= 2;
                    continue block7;
                }
                case 's': {
                    flags |= 0x20;
                    continue block7;
                }
                case 'm': {
                    flags |= 8;
                    continue block7;
                }
                case 'u': {
                    flags |= 0x40;
                    continue block7;
                }
                case 'x': {
                    flags |= 4;
                    continue block7;
                }
                default: {
                    throw EvaluationException.create(this.sourceRange, "MSG_INVALID_REGEXP_FLAG", Character.valueOf(c));
                }
            }
        }
        return flags;
    }

    protected Pattern compilePattern(Element regex, int flags) {
        Pattern p = null;
        try {
            String re = ((StringProperty)regex).getValue();
            p = Pattern.compile(re, flags);
        }
        catch (PatternSyntaxException pse) {
            throw EvaluationException.create(this.sourceRange, "MSG_INVALID_REGEXP", pse.getLocalizedMessage());
        }
        return p;
    }
}

