/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.data;

import net.jcip.annotations.Immutable;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;
import org.quattor.pan.utils.TermFactory;

@Immutable
public class StringProperty
extends Property
implements Term {
    protected StringProperty(String value) {
        super(value);
    }

    public static StringProperty getInstance(String value) {
        return new StringProperty(value);
    }

    @Override
    public void checkRange(Range range2) throws ValidationException {
        if (!range2.isInRange(this.getValue().length())) {
            throw ValidationException.create("MSG_STRING_SIZE_OUTSIDE_RANGE", this.getValue().length(), range2.toString());
        }
    }

    @Override
    public String getValue() {
        return (String)super.getValue();
    }

    @Override
    public String getTypeAsString() {
        return "string";
    }

    @Override
    public boolean isKey() {
        return true;
    }

    @Override
    public Integer getIndex() throws InvalidTermException {
        throw new InvalidTermException(this.getKey());
    }

    @Override
    public String getKey() throws InvalidTermException {
        return this.getValue();
    }

    @Override
    public int compareTo(Term o) {
        return TermFactory.compare(this, o);
    }
}

