/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.data;

import java.util.List;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;

public class ProtectedListResource
extends ListResource {
    private final ListResource baseList;

    public ProtectedListResource(ListResource baseList) {
        this.baseList = baseList;
    }

    @Override
    public Element duplicate() {
        return this.baseList.duplicate();
    }

    @Override
    public Element get(Term key2) throws InvalidTermException {
        Element value = this.baseList.get(key2);
        if (value != null) {
            return value.protect();
        }
        return value;
    }

    @Override
    public Element put(Term key2, Element newValue) throws InvalidTermException {
        throw CompilerError.create("MSG_ILLEGAL_WRITE_TO_PROTECTED_LIST", new Object[0]);
    }

    @Override
    public Element put(int index2, Element newValue) {
        throw CompilerError.create("MSG_ILLEGAL_WRITE_TO_PROTECTED_LIST", new Object[0]);
    }

    @Override
    public void append(Element e2) {
        throw CompilerError.create("MSG_ILLEGAL_WRITE_TO_PROTECTED_LIST", new Object[0]);
    }

    @Override
    public void prepend(Element e2) {
        throw CompilerError.create("MSG_ILLEGAL_WRITE_TO_PROTECTED_LIST", new Object[0]);
    }

    @Override
    public int size() {
        return this.baseList.size();
    }

    @Override
    public Resource.Iterator iterator() {
        return this.baseList.protectedIterator();
    }

    @Override
    public Resource.Iterator protectedIterator() {
        return this.baseList.protectedIterator();
    }

    @Override
    public void checkRange(Range range2) throws ValidationException {
        this.baseList.checkRange(range2);
    }

    @Override
    public Element protect() {
        return this;
    }

    @Override
    public int hashCode() {
        return this.baseList.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    protected List<Element> getBackingList() {
        return this.baseList.getBackingList();
    }

    @Override
    public String toString() {
        return this.baseList.toString();
    }

    @Override
    public boolean isProtected() {
        return true;
    }

    @Override
    public void rput(Term[] terms, int index2, Element value) throws InvalidTermException {
        throw CompilerError.create("MSG_ILLEGAL_WRITE_TO_PROTECTED_LIST", new Object[0]);
    }

    @Override
    public Element writableCopy() {
        return new ListResource(this.baseList);
    }
}

