/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.data;

import net.jcip.annotations.Immutable;
import org.quattor.pan.dml.data.NumberProperty;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;
import org.quattor.pan.utils.TermFactory;

@Immutable
public final class LongProperty
extends NumberProperty
implements Term {
    private LongProperty(Long value) {
        super(value);
    }

    public static LongProperty getInstance(long value) {
        return new LongProperty(value);
    }

    public static LongProperty getInstance(Long value) {
        return new LongProperty(value);
    }

    public static LongProperty getInstance(String value) {
        return new LongProperty(Long.decode(value));
    }

    @Override
    public void checkRange(Range range2) throws ValidationException {
        if (!range2.isInRange(this.getValue())) {
            throw ValidationException.create("MSG_NUMBER_OUTSIDE_RANGE", this.getValue(), range2.toString());
        }
    }

    @Override
    public double doubleValue() {
        return this.getValue().doubleValue();
    }

    @Override
    public Long getValue() {
        return (Long)super.getValue();
    }

    @Override
    public String getTypeAsString() {
        return "long";
    }

    @Override
    public boolean isKey() {
        return false;
    }

    @Override
    public Integer getIndex() throws InvalidTermException {
        return this.getValue().intValue();
    }

    @Override
    public String getKey() throws InvalidTermException {
        throw new InvalidTermException(this.getIndex().toString());
    }

    @Override
    public int compareTo(Term o) {
        return TermFactory.compare(this, o);
    }
}

