/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.data;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.ProtectedListResource;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;

public class ListResource
extends Resource {
    private List<Element> list;

    public ListResource() {
        this.list = new ArrayList<Element>();
    }

    public ListResource(Element[] args) {
        this.list = new ArrayList<Element>();
        for (Element arg : args) {
            this.list.add(arg);
        }
    }

    private ListResource(List<Element> childrenList) {
        try {
            this.list = new ArrayList<Element>(childrenList.size());
            for (Element element : childrenList) {
                Element clone = element.duplicate();
                this.list.add(clone);
            }
        }
        catch (StackOverflowError e2) {
            throw new EvaluationException("stack overflow; check for circular data structure");
        }
    }

    protected ListResource(ListResource source2) {
        ArrayList<Element> alist = new ArrayList<Element>(source2.list.size());
        for (Element e2 : source2.list) {
            alist.add(e2.protect());
        }
        alist.trimToSize();
        this.list = alist;
    }

    @Override
    public Element duplicate() {
        return new ListResource(this.list);
    }

    @Override
    public Element get(Term term) throws InvalidTermException {
        assert (term != null);
        Element value = null;
        int index2 = 0;
        try {
            index2 = term.getIndex();
            value = this.list.get(index2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return value;
    }

    @Override
    public Element put(Term term, Element value) throws InvalidTermException {
        assert (term != null);
        return this.put(term.getIndex(), value);
    }

    public Element put(int index2, Element newValue) {
        Element oldValue = null;
        if (index2 < 0) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_LIST_INDEX", Integer.toString(index2)));
        }
        try {
            if (newValue != null && !(newValue instanceof Null)) {
                int size = this.list.size();
                if (index2 >= size) {
                    for (int i = 0; i < index2 - size; ++i) {
                        this.list.add(Undef.VALUE);
                    }
                    this.list.add(newValue);
                } else {
                    oldValue = this.list.set(index2, newValue);
                    if (oldValue != null) {
                        oldValue.checkValidReplacement(newValue);
                    }
                }
            } else {
                try {
                    oldValue = this.list.remove(index2);
                }
                catch (IndexOutOfBoundsException size) {}
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new EvaluationException(MessageUtils.format("MSG_NONEXISTANT_LIST_ELEMENT", Integer.toString(index2)));
        }
        return oldValue;
    }

    public void append(Element e2) {
        assert (e2 != null);
        this.list.add(e2);
    }

    public void prepend(Element e2) {
        assert (e2 != null);
        this.list.add(0, e2);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Resource.Iterator iterator() {
        return new ListResourceIterator(this.list, false);
    }

    public Resource.Iterator protectedIterator() {
        return new ListResourceIterator(this.list, true);
    }

    @Override
    public void checkRange(Range range2) throws ValidationException {
        if (!range2.isInRange(this.list.size())) {
            throw ValidationException.create("MSG_LIST_SIZE_OUTSIDE_RANGE", this.list.size(), range2.toString());
        }
    }

    @Override
    public void checkValidReplacement(Element newValue) throws EvaluationException {
        if (!(newValue instanceof Undef || newValue instanceof Null || newValue instanceof ListResource)) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_REPLACEMENT", this.getTypeAsString(), newValue.getTypeAsString()));
        }
    }

    @Override
    public Element protect() {
        return new ProtectedListResource(this);
    }

    @Override
    public String getTypeAsString() {
        return "list";
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ListResource) {
            return this.list.equals(((ListResource)o).list);
        }
        return false;
    }

    protected List<Element> getBackingList() {
        return this.list;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        String separator = "";
        for (Resource.Entry entry : this) {
            sb.append(separator);
            sb.append(((Element)entry.getValue()).toString());
            separator = ", ";
        }
        sb.append(" ]");
        return sb.toString();
    }

    private static class ListResourceEntry
    implements Resource.Entry {
        private final Property key;
        private final Element value;

        public ListResourceEntry(Property key2, Element value) {
            assert (key2 != null);
            assert (value != null);
            this.key = key2;
            this.value = value;
        }

        @Override
        public Property getKey() {
            return this.key;
        }

        @Override
        public Element getValue() {
            return this.value;
        }

        @Override
        public Element setValue(Element value) {
            throw new UnsupportedOperationException("ListResourceEntry does not support setValue()");
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ListResourceEntry) {
                ListResourceEntry other = (ListResourceEntry)o;
                return this.key.equals(other.key) && this.value.equals(other.value);
            }
            return false;
        }
    }

    private static class ListResourceIterator
    implements Resource.Iterator {
        private final AtomicInteger index = new AtomicInteger(0);
        private final List<Element> backingList;
        private final boolean isProtected;

        public ListResourceIterator(List<Element> backingList, boolean isProtected) {
            assert (backingList != null);
            this.backingList = backingList;
            this.isProtected = isProtected;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ListResourceIterator does not support remove()");
        }

        @Override
        public boolean hasNext() {
            return this.index.get() < this.backingList.size();
        }

        @Override
        public Resource.Entry next() {
            try {
                int i = this.index.getAndIncrement();
                Element value = this.backingList.get(i);
                if (this.isProtected && value != null) {
                    value = value.protect();
                }
                ListResourceEntry entry = new ListResourceEntry(LongProperty.getInstance(i), value);
                return entry;
            }
            catch (NoSuchElementException nsee) {
                throw new EvaluationException(MessageUtils.format("MSG_CONCURRENT_MODIFICATION", new Object[0]), null);
            }
        }
    }
}

