/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.data;

import net.jcip.annotations.Immutable;
import org.quattor.pan.dml.data.NumberProperty;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.utils.Range;

@Immutable
public final class DoubleProperty
extends NumberProperty {
    private DoubleProperty(Double value) {
        super(value);
    }

    public static DoubleProperty getInstance(double value) {
        return new DoubleProperty(value);
    }

    public static DoubleProperty getInstance(Double value) {
        return new DoubleProperty(value);
    }

    public static DoubleProperty getInstance(String value) {
        return new DoubleProperty(Double.parseDouble(value));
    }

    @Override
    public void checkRange(Range range2) throws ValidationException {
        if (!range2.isInRange(this.doubleValue())) {
            throw ValidationException.create("MSG_NUMBER_OUTSIDE_RANGE", this.getValue(), range2.toString());
        }
    }

    @Override
    public double doubleValue() {
        return this.getValue();
    }

    @Override
    public Double getValue() {
        return (Double)super.getValue();
    }

    @Override
    public String getTypeAsString() {
        return "double";
    }
}

