/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.data;

import clojure.lang.AFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;

public abstract class AbstractElement
extends AFn
implements Element {
    private final AtomicReference<IPersistentMap> metadataRef = new AtomicReference();

    @Override
    public IPersistentMap meta() {
        return this.metadataRef.get();
    }

    @Override
    public IObj withMeta(IPersistentMap iPersistentMap) {
        this.metadataRef.set(iPersistentMap);
        return this;
    }

    @Override
    public Object invoke(Object o1) {
        try {
            return this.execute((Context)o1);
        }
        catch (ClassCastException ex) {
            throw CompilerError.create("MSG_OPERATION_WITHOUT_CONTEXT", new Object[0]);
        }
    }

    @Override
    public void checkRange(Range range2) throws ValidationException {
        throw ValidationException.create("MSG_INVALID_RANGE_CHECK", this.getTypeAsString());
    }

    @Override
    public Element execute(Context context) throws EvaluationException {
        return this;
    }

    @Override
    public Element duplicate() {
        return this;
    }

    @Override
    public Element writableCopy() {
        return this;
    }

    @Override
    public void checkRestrictedContext() throws SyntaxException {
    }

    @Override
    public void checkInvalidSelfContext() throws SyntaxException {
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public void checkValidReplacement(Element newValue) throws EvaluationException {
        if (!(newValue instanceof Undef || newValue instanceof Null || this.getClass().isAssignableFrom(newValue.getClass()))) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_REPLACEMENT", this.getTypeAsString(), newValue.getTypeAsString()));
        }
    }

    @Override
    public Element protect() {
        return this;
    }

    @Override
    public Element rget(Term[] terms, int index2, boolean protect, boolean lookupOnly) throws InvalidTermException {
        if (!lookupOnly) {
            throw new EvaluationException(MessageUtils.format("MSG_ILLEGAL_DEREFERENCE", this.getTypeAsString()));
        }
        return null;
    }

    @Override
    public ListResource rgetList(Term[] terms, int index2) throws InvalidTermException {
        throw new EvaluationException(MessageUtils.format("MSG_ILLEGAL_DEREFERENCE", this.getTypeAsString()));
    }

    @Override
    public void rput(Term[] terms, int index2, Element value) throws InvalidTermException {
        throw new EvaluationException(MessageUtils.format("MSG_CANNOT_ADD_CHILD", this.getTypeAsString()));
    }

    @Override
    public abstract String getTypeAsString();

    @Override
    public abstract String toString();

    @Override
    public abstract int hashCode();

    @Override
    public abstract boolean equals(Object var1);
}

