/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml;

import java.util.LinkedList;
import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public class DML
extends AbstractOperation {
    protected DML(SourceRange sourceRange, Operation ... operations) {
        super(sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) {
        DML dml = DML.getUnoptimizedInstance(sourceRange, operations);
        if (dml.ops.length == 1) {
            return dml.ops[0];
        }
        return dml;
    }

    public static DML getUnoptimizedInstance(SourceRange sourceRange, Operation ... operations) {
        LinkedList<Operation> list = new LinkedList<Operation>();
        for (Operation op : operations) {
            if (op instanceof DML) {
                DML dml = (DML)op;
                for (Operation dmlOp : dml.ops) {
                    list.add(dmlOp);
                }
                continue;
            }
            list.add(op);
        }
        Operation[] dmlOps = list.toArray(new Operation[list.size()]);
        return new DML(sourceRange, dmlOps);
    }

    @Override
    public Element execute(Context context) {
        Element result = Undef.VALUE;
        for (Operation op : this.ops) {
            try {
                result = op.execute(context);
            }
            catch (EvaluationException ee) {
                throw ee.addExceptionInfo(this.sourceRange, context);
            }
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Operation op : this.ops) {
            sb.append(" ");
            sb.append(op.toString());
            sb.append(" ");
        }
        sb.append("}");
        return sb.toString();
    }
}

