/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml;

import clojure.lang.AFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Term;
import org.quattor.pan.utils.TermFactory;

public abstract class AbstractOperation
extends AFn
implements Operation {
    protected final SourceRange sourceRange;
    protected final Operation[] ops;
    private final AtomicReference<IPersistentMap> metadataRef = new AtomicReference();

    public AbstractOperation(SourceRange sourceRange, Operation ... operations) {
        this.sourceRange = sourceRange;
        this.ops = (Operation[])operations.clone();
    }

    @Override
    public IPersistentMap meta() {
        return this.metadataRef.get();
    }

    @Override
    public IObj withMeta(IPersistentMap iPersistentMap) {
        this.metadataRef.set(iPersistentMap);
        return this;
    }

    @Override
    public Object invoke(Object o1) {
        try {
            return this.execute((Context)o1);
        }
        catch (ClassCastException ex) {
            throw CompilerError.create("MSG_OPERATION_WITHOUT_CONTEXT", new Object[0]);
        }
    }

    @Override
    public abstract Element execute(Context var1) throws EvaluationException;

    @Override
    public void checkRestrictedContext() throws SyntaxException {
        for (Operation op : this.ops) {
            op.checkRestrictedContext();
        }
    }

    @Override
    public void checkInvalidSelfContext() throws SyntaxException {
        for (Operation op : this.ops) {
            op.checkInvalidSelfContext();
        }
    }

    protected Element[] calculateArgs(Context context) throws EvaluationException {
        Element[] results = new Element[this.ops.length];
        for (int i = 0; i < this.ops.length; ++i) {
            results[i] = this.ops[i].execute(context);
        }
        return results;
    }

    protected Term[] calculateTerms(Context context) throws EvaluationException {
        Term[] terms = new Term[this.ops.length];
        for (int i = 0; i < this.ops.length; ++i) {
            terms[i] = TermFactory.create(this.ops[i].execute(context));
        }
        return terms;
    }

    public SourceRange getSourceRange() {
        return this.sourceRange;
    }

    public Operation[] getOperations() {
        return (Operation[])this.ops.clone();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

