/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.cache;

import java.io.File;
import java.net.URI;
import java.util.concurrent.Future;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.cache.AbstractCache;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.parser.ASTTemplate;
import org.quattor.pan.tasks.CompileResult;
import org.quattor.pan.tasks.CompileTask;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.tasks.WriteAnnotationTask;
import org.quattor.pan.tasks.WriteOutputTask;
import org.quattor.pan.template.Template;
import org.quattor.pan.utils.FileUtils;

public class CompileCache
extends AbstractCache<CompileResult> {
    private final PostCompileProcessor postCompileProcessor;

    public CompileCache(Compiler compiler) {
        this(compiler, 1000);
    }

    public CompileCache(Compiler compiler, int size) {
        super(compiler, size);
        this.postCompileProcessor = new PostCompileProcessor(compiler);
    }

    public Future<CompileResult> compile(String tplfile) {
        CompileTask task = this.createTask(tplfile);
        this.compiler.submit(task);
        return task;
    }

    protected CompileTask createTask(String tplfile) {
        return new CompileTask(tplfile, this.postCompileProcessor, this.compiler.options);
    }

    @Override
    protected TaskResult.ResultType getExecutorQueueType() {
        return TaskResult.ResultType.COMPILED;
    }

    public static final String getRelativePath(File baseDirectory, File file2) {
        URI fileURI;
        URI baseURI;
        URI relativeURI;
        String relativePath = null;
        if (baseDirectory != null && file2 != null && !(relativeURI = (baseURI = baseDirectory.toURI()).relativize(fileURI = file2.toURI())).isAbsolute()) {
            relativePath = relativeURI.toString();
        }
        return relativePath;
    }

    public static File annotationOutputFile(File annotationDirectory, String relativePath) {
        if (relativePath != null) {
            String relativeOutputPath = relativePath + ".annotation.xml";
            relativeOutputPath = FileUtils.localizeFilename(relativeOutputPath);
            return new File(annotationDirectory, relativeOutputPath);
        }
        return null;
    }

    public static class PostCompileProcessor {
        private final Compiler compiler;
        private final CompilerOptions options;

        public PostCompileProcessor(Compiler compiler) {
            this.compiler = compiler;
            this.options = compiler.options;
        }

        public void process(ASTTemplate ast2, Template template2) {
            boolean doAnno;
            Task task;
            if (template2.type == Template.TemplateType.OBJECT) {
                String objectName = template2.name;
                for (Formatter formatter2 : this.options.formatters) {
                    File outputDirectory = this.options.outputDirectory;
                    task = new WriteOutputTask(formatter2, this.compiler, objectName, outputDirectory);
                    this.compiler.submit(task);
                }
            }
            boolean bl = doAnno = this.options.annotationDirectory != null && this.options.annotationBaseDirectory != null && template2.sourceFile != null;
            if (doAnno) {
                String relativePath = CompileCache.getRelativePath(this.options.annotationBaseDirectory, template2.sourceFile.getPath());
                File outputFile = CompileCache.annotationOutputFile(this.options.annotationDirectory, relativePath);
                task = new WriteAnnotationTask(outputFile, ast2);
                this.compiler.submit(task);
            }
        }
    }
}

