/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.cache;

import java.util.HashMap;
import java.util.Map;
import org.quattor.pan.Compiler;
import org.quattor.pan.cache.AbstractCache;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.tasks.BuildResult;
import org.quattor.pan.tasks.BuildTask;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;

public class BuildCache
extends AbstractCache<BuildResult> {
    private final Map<String, String> dependencies = new HashMap<String, String>();

    public BuildCache(Compiler compiler) {
        this(compiler, 1000);
    }

    public BuildCache(Compiler compiler, int size) {
        super(compiler, size);
    }

    @Override
    protected Task<BuildResult> createTask(String objectName) {
        return new BuildTask(this.compiler, objectName);
    }

    @Override
    protected TaskResult.ResultType getExecutorQueueType() {
        return TaskResult.ResultType.BUILD;
    }

    public synchronized void setDependency(String objectName, String dependencyName) throws EvaluationException {
        String nextObjectName = this.dependencies.get(dependencyName);
        while (nextObjectName != null) {
            if (objectName.equals(nextObjectName)) {
                throw EvaluationException.create("MSG_CIRCULAR_OBJECT_DEPENDENCY", this.getCycle(objectName, dependencyName));
            }
            nextObjectName = this.dependencies.get(nextObjectName);
        }
        this.dependencies.put(objectName, dependencyName);
        this.compiler.ensureMinimumBuildThreadLimit(this.dependencies.size() + 1);
    }

    private synchronized String getCycle(String objectName, String dependencyName) {
        StringBuilder sb = new StringBuilder();
        sb.append(objectName);
        sb.append(" -> ");
        sb.append(dependencyName);
        String nextObjectName = this.dependencies.get(dependencyName);
        while (nextObjectName != null && !objectName.equals(nextObjectName)) {
            sb.append(" -> ");
            sb.append(nextObjectName);
            nextObjectName = this.dependencies.get(nextObjectName);
        }
        sb.append(" -> ");
        sb.append(objectName);
        return sb.toString();
    }
}

