/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.cache;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.quattor.pan.Compiler;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.utils.ExceptionUtils;

public abstract class AbstractCache<T extends TaskResult> {
    protected final Compiler compiler;
    private final ConcurrentHashMap<String, Task<T>> cache;

    protected AbstractCache(Compiler compiler, int size) {
        assert (compiler != null);
        assert (size > 0);
        this.compiler = compiler;
        this.cache = new ConcurrentHashMap(size);
    }

    public Future<T> retrieve(String key2, boolean executeInline) {
        assert (key2 != null);
        boolean createdTask = false;
        Task<T> task = this.cache.get(key2);
        if (task == null) {
            Task<T> newTask = this.createTask(key2);
            Task<T> existingEntry = this.cache.putIfAbsent(key2, newTask);
            if (existingEntry == null) {
                createdTask = true;
                task = newTask;
            } else {
                task = existingEntry;
            }
        }
        if (executeInline) {
            task.run();
        } else if (createdTask) {
            this.compiler.submit(task);
        }
        return task;
    }

    public T waitForResult(String key2) throws RuntimeException, ValidationException {
        Future<T> future2 = this.retrieve(key2, true);
        TaskResult result = null;
        try {
            result = (TaskResult)future2.get();
        }
        catch (InterruptedException ie) {
            throw EvaluationException.create("MSG_INTERRUPTED_THREAD", key2);
        }
        catch (CancellationException ce) {
            throw EvaluationException.create("MSG_CANCELLED_THREAD", key2);
        }
        catch (ExecutionException ee) {
            throw ExceptionUtils.launder(ee);
        }
        return (T)result;
    }

    public Future<T> retrieve(String key2) {
        assert (key2 != null);
        return this.cache.get(key2);
    }

    protected abstract Task<T> createTask(String var1);

    protected abstract TaskResult.ResultType getExecutorQueueType();
}

