/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.quattor.pan.utils.MessageUtils;

public class Annotation
implements Iterable<Entry> {
    private static final Pattern xmlPrefix = Pattern.compile("^[Xx][Mm][Ll].*", 32);
    private static final Pattern validKeyChars = Pattern.compile("^[A-Za-z_]+[A-Za-z_\\.\\-]*$");
    private final String name;
    private final List<Entry> entries;

    public Annotation(String name2, List<Entry> entries) {
        String string2 = this.name = name2 != null ? name2 : "";
        if (!Annotation.validName(this.name)) {
            String msg = MessageUtils.format("MSG_INVALID_ANNOTATION_NAME_OR_KEY", this.name);
            throw new IllegalArgumentException(msg);
        }
        ArrayList<Entry> copy2 = null;
        if (entries != null) {
            copy2 = new ArrayList(entries.size());
            copy2.addAll(entries);
        } else {
            copy2 = new ArrayList<Entry>(0);
        }
        copy2.trimToSize();
        this.entries = Collections.unmodifiableList(copy2);
    }

    public String getName() {
        return this.name;
    }

    public boolean isAnonymous() {
        return "".equals(this.name);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public static boolean validName(String name2) {
        return "".equals(name2) || Annotation.validKey(name2);
    }

    public static boolean validKey(String key2) {
        if (key2 == null) {
            return false;
        }
        if (xmlPrefix.matcher(key2).matches()) {
            return false;
        }
        return validKeyChars.matcher(key2).matches();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("@" + this.name + "{\n");
        for (Entry entry : this.getEntries()) {
            sb.append("  ");
            sb.append(entry.toString());
            sb.append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public static class Entry {
        private final String key;
        private final String value;

        public Entry(String key2, String value) {
            this.key = key2;
            this.value = value;
            if (!Annotation.validKey(key2)) {
                String msg = MessageUtils.format("MSG_INVALID_ANNOTATION_NAME_OR_KEY", key2);
                throw new IllegalArgumentException(msg);
            }
            if (value == null) {
                String msg = MessageUtils.format("MSG_INVALID_ANNOTATION_NULL_VALUE", new Object[0]);
                throw new IllegalArgumentException(msg);
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s = %s", this.key, this.value);
        }
    }
}

