/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.utils.MessageUtils;

public class CompilerStatistics {
    private static final Logger memoryLogger = CompilerLogging.LoggingType.MEMORY.logger();
    private long buildTime = -1L;
    private long fileCount;
    private final AtomicLong heapUsed;
    private final AtomicLong heapTotal;
    private final AtomicLong nonHeapUsed;
    private final AtomicLong nonHeapTotal;
    private final Map<TaskResult.ResultType, AtomicLong> startedTasks = new TreeMap<TaskResult.ResultType, AtomicLong>();
    private final Map<TaskResult.ResultType, AtomicLong> doneTasks = new TreeMap<TaskResult.ResultType, AtomicLong>();

    public CompilerStatistics() {
        for (TaskResult.ResultType t : TaskResult.ResultType.values()) {
            this.startedTasks.put(t, new AtomicLong(0L));
            this.doneTasks.put(t, new AtomicLong(0L));
        }
        this.heapUsed = new AtomicLong(-1L);
        this.heapTotal = new AtomicLong(-1L);
        this.nonHeapUsed = new AtomicLong(-1L);
        this.nonHeapTotal = new AtomicLong(-1L);
        this.updateMemoryInfo();
    }

    public void setBuildTime(long buildTime) {
        this.buildTime = buildTime;
    }

    public void setFileCount(long fileCount) {
        this.fileCount = fileCount;
    }

    public void incrementStartedTasks(TaskResult.ResultType type2) {
        this.startedTasks.get((Object)type2).incrementAndGet();
    }

    public void incrementFinishedTasks(TaskResult.ResultType type2) {
        this.doneTasks.get((Object)type2).incrementAndGet();
    }

    public void updateMemoryInfo() {
        MemoryMXBean meminfo = ManagementFactory.getMemoryMXBean();
        MemoryUsage usage2 = meminfo.getHeapMemoryUsage();
        long _heapUsed = usage2.getUsed();
        CompilerStatistics.updateMaximum(this.heapUsed, _heapUsed);
        CompilerStatistics.updateMaximum(this.heapTotal, usage2.getMax());
        usage2 = meminfo.getNonHeapMemoryUsage();
        CompilerStatistics.updateMaximum(this.nonHeapUsed, usage2.getUsed());
        CompilerStatistics.updateMaximum(this.nonHeapTotal, usage2.getMax());
        if (memoryLogger.isLoggable(Level.INFO)) {
            memoryLogger.log(Level.INFO, "MEM", new Object[]{_heapUsed});
        }
    }

    private static void updateMaximum(AtomicLong counter, long currentValue) {
        boolean unset = true;
        long counterValue = counter.get();
        while (currentValue > counterValue && unset) {
            unset = !counter.compareAndSet(counterValue, currentValue);
            counterValue = counter.get();
        }
    }

    public String getResults(long totalErrors) {
        Object[] info = new Object[]{this.fileCount, this.doneTasks.get((Object)TaskResult.ResultType.COMPILED).get(), this.startedTasks.get((Object)TaskResult.ResultType.COMPILED).get(), this.doneTasks.get((Object)TaskResult.ResultType.ANNOTATION).get(), this.startedTasks.get((Object)TaskResult.ResultType.ANNOTATION).get(), this.doneTasks.get((Object)TaskResult.ResultType.XML).get(), this.startedTasks.get((Object)TaskResult.ResultType.XML).get(), this.doneTasks.get((Object)TaskResult.ResultType.DEP).get(), this.startedTasks.get((Object)TaskResult.ResultType.DEP).get(), totalErrors, this.buildTime, CompilerStatistics.convertToMB(this.heapUsed.get()), CompilerStatistics.convertToMB(this.heapTotal.get()), CompilerStatistics.convertToMB(this.nonHeapUsed.get()), CompilerStatistics.convertToMB(this.nonHeapTotal.get())};
        return MessageUtils.format("MSG_STATISTICS_TEMPLATE", info);
    }

    private static Long convertToMB(long value) {
        return value >> 20;
    }
}

