/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan;

import java.io.File;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.ConfigurationException;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.output.DepFormatter;
import org.quattor.pan.output.DotFormatter;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.output.JsonFormatter;
import org.quattor.pan.output.JsonGzipFormatter;
import org.quattor.pan.output.NullFormatter;
import org.quattor.pan.output.PanFormatter;
import org.quattor.pan.output.PanGzipFormatter;
import org.quattor.pan.output.TxtFormatter;
import org.quattor.pan.output.XmlFormatter;
import org.quattor.pan.output.XmlGzipFormatter;
import org.quattor.pan.parser.ASTOperation;
import org.quattor.pan.parser.PanParser;
import org.quattor.pan.parser.PanParserAstUtils;
import org.quattor.pan.repository.ParameterList;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.repository.SourceRepository;
import org.quattor.pan.repository.SourceRepositoryFactory;
import org.quattor.pan.template.CompileTimeContext;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public class CompilerOptions {
    public final int maxIteration;
    public final int maxRecursion;
    public final List<Formatter> formatters;
    public final File outputDirectory;
    public final DeprecationWarnings deprecationWarnings;
    public final SourceRepository sourceRepository;
    private final Pattern debugNsInclude;
    private final Pattern debugNsExclude;
    public final File annotationDirectory;
    public final File annotationBaseDirectory;
    public final HashResource rootElement;
    public final int nthread;

    public CompilerOptions(Pattern debugNsInclude, Pattern debugNsExclude, int maxIteration, int maxRecursion, Set<Formatter> formatters, File outputDirectory, List<File> includeDirectories, DeprecationWarnings deprecationWarnings, File annotationDirectory, File annotationBaseDirectory, String rootElement, int nthread) throws SyntaxException {
        if (maxIteration <= 0) {
            maxIteration = Integer.MAX_VALUE;
        }
        if (maxRecursion <= 0) {
            maxRecursion = Integer.MAX_VALUE;
        }
        if (outputDirectory != null) {
            this.checkDirectory(outputDirectory, "output");
        }
        for (File d : includeDirectories) {
            if (d != null) {
                this.checkDirectory(d, "include");
                continue;
            }
            throw new IllegalArgumentException("include directory may not be null");
        }
        if (outputDirectory == null && formatters.size() > 0) {
            throw new IllegalArgumentException("outputDirectory must be specified if output formats are specified");
        }
        this.maxIteration = maxIteration;
        this.maxRecursion = maxRecursion;
        this.outputDirectory = outputDirectory;
        this.deprecationWarnings = deprecationWarnings;
        LinkedList<Formatter> fmts = new LinkedList<Formatter>();
        if (formatters != null) {
            fmts.addAll(formatters);
        }
        this.formatters = Collections.unmodifiableList(fmts);
        this.debugNsInclude = debugNsInclude;
        this.debugNsExclude = debugNsExclude;
        ParameterList parameters = new ParameterList();
        for (File f : includeDirectories) {
            parameters.append("includeDirectory", f.toString());
        }
        SourceRepository value = null;
        try {
            value = SourceRepositoryFactory.create(parameters);
        }
        catch (ConfigurationException ce) {
            throw new RuntimeException(ce.getMessage());
        }
        this.sourceRepository = value;
        this.annotationDirectory = annotationDirectory;
        if (annotationDirectory != null) {
            this.checkDirectory(annotationDirectory, "annotation");
        }
        this.annotationBaseDirectory = annotationBaseDirectory;
        if (annotationBaseDirectory != null) {
            this.checkDirectory(annotationBaseDirectory, "annotation base");
        }
        this.rootElement = CompilerOptions.createRootElement(rootElement);
        int nprocs = Runtime.getRuntime().availableProcessors();
        this.nthread = nthread <= 0 || nthread > nprocs ? nprocs : nthread;
    }

    public static DeprecationWarnings getDeprecationWarnings(int deprecationLevel, boolean failOnWarn) {
        if (deprecationLevel < 0) {
            return DeprecationWarnings.OFF;
        }
        return failOnWarn ? DeprecationWarnings.FATAL : DeprecationWarnings.ON;
    }

    public static CompilerOptions createCheckSyntaxOptions(DeprecationWarnings deprecationWarnings) {
        Pattern debugNsInclude = null;
        Pattern debugNsExclude = null;
        int maxIteration = 5000;
        int maxRecursion = 50;
        HashSet<Formatter> formatters = new HashSet<Formatter>();
        File outputDirectory = null;
        File annotationDirectory = null;
        File annotationBaseDirectory = null;
        LinkedList<File> includeDirectories = new LinkedList<File>();
        try {
            return new CompilerOptions(debugNsInclude, debugNsExclude, maxIteration, maxRecursion, formatters, outputDirectory, includeDirectories, deprecationWarnings, annotationDirectory, annotationBaseDirectory, null, 0);
        }
        catch (SyntaxException consumed) {
            throw CompilerError.create("MSG_FILE_BUG_REPORT", new Object[0]);
        }
    }

    public static CompilerOptions createAnnotationOptions(File annotationDirectory, File annotationBaseDirectory) {
        Pattern debugNsInclude = null;
        Pattern debugNsExclude = null;
        int maxIteration = 5000;
        int maxRecursion = 50;
        HashSet<Formatter> formatters = new HashSet<Formatter>();
        File outputDirectory = null;
        LinkedList<File> includeDirectories = new LinkedList<File>();
        try {
            return new CompilerOptions(debugNsInclude, debugNsExclude, maxIteration, maxRecursion, formatters, outputDirectory, includeDirectories, DeprecationWarnings.OFF, annotationDirectory, annotationBaseDirectory, null, 0);
        }
        catch (SyntaxException consumed) {
            throw CompilerError.create("MSG_FILE_BUG_REPORT", new Object[0]);
        }
    }

    public static HashResource createRootElement(String rootElement) throws SyntaxException {
        if (rootElement == null || "".equals(rootElement.trim())) {
            return new HashResource();
        }
        try {
            PanParser parser = new PanParser(new StringReader(rootElement));
            ASTOperation ast2 = parser.dml();
            Operation dml = PanParserAstUtils.astToDml(ast2, true);
            return (HashResource)dml.execute(new CompileTimeContext());
        }
        catch (SyntaxException e2) {
            throw SyntaxException.create(null, "MSG_INVALID_SYNTAX_ROOT_ELEMENT", e2.getMessage());
        }
        catch (ClassCastException e3) {
            throw SyntaxException.create(null, "MSG_INVALID_TYPE_FOR_ROOT_ELEMENT", new Object[0]);
        }
    }

    private void checkDirectory(File d, String dtype) {
        if (!d.isAbsolute()) {
            throw new IllegalArgumentException(dtype + " directory must be an absolute path (" + d.getPath() + ")");
        }
        if (!d.exists()) {
            throw new IllegalArgumentException(dtype + " directory does not exist (" + d.getPath() + ")");
        }
        if (!d.isDirectory()) {
            throw new IllegalArgumentException(dtype + " directory value is not a directory (" + d.getPath() + ")");
        }
    }

    public Set<File> resolveFileList(List<String> objectNames, Collection<File> tplFiles) {
        TreeSet<File> filesToProcess = new TreeSet<File>();
        if (tplFiles != null) {
            filesToProcess.addAll(tplFiles);
        }
        if (objectNames != null) {
            for (String oname : objectNames) {
                SourceFile source2 = this.sourceRepository.retrievePanSource(oname);
                if (!source2.isAbsent()) {
                    filesToProcess.add(source2.getPath());
                    continue;
                }
                throw EvaluationException.create((SourceRange)null, (Context)null, "MSG_CANNOT_LOCATE_OBJECT_TEMPLATE", oname);
            }
        }
        return Collections.unmodifiableSet(filesToProcess);
    }

    public boolean checkDebugEnabled(String tplName) {
        if (this.debugNsExclude != null && this.debugNsExclude.matcher(tplName).matches()) {
            return false;
        }
        return this.debugNsInclude != null && this.debugNsInclude.matcher(tplName).matches();
    }

    public static Set<Formatter> getFormatters(String s) {
        String[] names;
        HashSet<Formatter> formatters = new HashSet<Formatter>();
        for (String fname : names = s.trim().split("\\s*,\\s*")) {
            if ("text".equals(fname)) {
                formatters.add(TxtFormatter.getInstance());
                continue;
            }
            if ("json".equals(fname)) {
                formatters.add(JsonFormatter.getInstance());
                continue;
            }
            if ("json.gz".equals(fname)) {
                formatters.add(JsonGzipFormatter.getInstance());
                continue;
            }
            if ("dot".equals(fname)) {
                formatters.add(DotFormatter.getInstance());
                continue;
            }
            if ("pan".equals(fname)) {
                formatters.add(PanFormatter.getInstance());
                continue;
            }
            if ("pan.gz".equals(fname)) {
                formatters.add(PanGzipFormatter.getInstance());
                continue;
            }
            if ("xml".equals(fname)) {
                formatters.add(XmlFormatter.getInstance());
                continue;
            }
            if ("xml.gz".equals(fname)) {
                formatters.add(XmlGzipFormatter.getInstance());
                continue;
            }
            if ("dep".equals(fname)) {
                formatters.add(DepFormatter.getInstance());
                continue;
            }
            if ("null".equals(fname)) {
                formatters.add(NullFormatter.getInstance());
                continue;
            }
            if (!"none".equals(fname)) continue;
        }
        return formatters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("debug include pattern: ");
        sb.append(this.debugNsInclude);
        sb.append("\n");
        sb.append("debug exclude pattern: ");
        sb.append(this.debugNsExclude);
        sb.append("\n");
        sb.append("\n");
        sb.append("output directory: ");
        sb.append(this.outputDirectory);
        sb.append("\n");
        sb.append("annotation source base directory: ");
        sb.append(this.annotationBaseDirectory);
        sb.append("\n");
        sb.append("annotation output base directory: ");
        sb.append(this.annotationDirectory);
        sb.append("\n");
        sb.append("\n");
        sb.append("formatters: ");
        if (this.formatters != null) {
            for (Formatter f : this.formatters) {
                sb.append(f.getFormatKey());
                sb.append("\n");
            }
        } else {
            sb.append("null");
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("rootElement: ");
        sb.append(this.rootElement);
        sb.append("\n");
        sb.append("source repository: ");
        sb.append(this.sourceRepository);
        sb.append("\n");
        sb.append("max. iteration: ");
        sb.append(this.maxIteration);
        sb.append("\n");
        sb.append("max. recursion: ");
        sb.append(this.maxRecursion);
        sb.append("\n");
        sb.append("deprecation warnings: ");
        sb.append((Object)this.deprecationWarnings);
        sb.append("\n");
        return sb.toString();
    }

    public static enum DeprecationWarnings {
        ON,
        OFF,
        FATAL;


        public static DeprecationWarnings fromString(String s) {
            return DeprecationWarnings.valueOf(s.toUpperCase());
        }
    }
}

