/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan;

import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CompilerLogging {
    private static final Logger topLogger = Logger.getLogger("org.quattor.pan");
    private static String initializedLogFile;

    private CompilerLogging() {
    }

    public static void activateLoggers(String loggerList) {
        EnumSet<LoggingType> flags = EnumSet.noneOf(LoggingType.class);
        for (String name2 : loggerList.split("\\s*,\\s*")) {
            try {
                flags.add(LoggingType.valueOf(name2.trim().toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (LoggingType type2 : flags) {
            type2.activate();
        }
    }

    private static void initializeLogger(Logger logger) {
        topLogger.setUseParentHandlers(false);
        for (Handler handler : topLogger.getHandlers()) {
            try {
                topLogger.removeHandler(handler);
            }
            catch (SecurityException consumed) {
                System.err.println("WARNING: missing 'LoggingPermission(\"control\")' permission");
            }
        }
    }

    public static synchronized void setLogFile(File logfile) {
        try {
            if (logfile != null) {
                String absolutePath = logfile.getAbsolutePath();
                if (initializedLogFile == null || !initializedLogFile.equals(absolutePath)) {
                    CompilerLogging.initializeLogger(topLogger);
                    FileHandler handler = new FileHandler(absolutePath);
                    handler.setFormatter(new LogFormatter());
                    topLogger.addHandler(handler);
                    initializedLogFile = absolutePath;
                }
            }
        }
        catch (IOException consumed) {
            StringBuilder sb = new StringBuilder();
            sb.append("WARNING: unable to open logging file handler\n");
            sb.append("WARNING: logfile = '" + logfile.getAbsolutePath() + "'");
            sb.append("\nWARNING: message = ");
            sb.append(consumed.getMessage());
            System.err.println(sb.toString());
        }
    }

    static {
        topLogger.setLevel(Level.OFF);
        CompilerLogging.initializeLogger(topLogger);
        initializedLogFile = null;
    }

    private static class LogFormatter
    extends Formatter {
        private LogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(record.getMillis());
            sb.append(" ");
            sb.append(record.getThreadID());
            sb.append(" ");
            sb.append(record.getMessage());
            for (Object o : record.getParameters()) {
                if (o == null) continue;
                sb.append(" ");
                sb.append(o.toString());
            }
            sb.append("\n");
            return sb.toString();
        }
    }

    public static enum LoggingType {
        TASK{

            @Override
            public Logger logger() {
                return Logger.getLogger("org.quattor.pan.task");
            }
        }
        ,
        INCLUDE{

            @Override
            public Logger logger() {
                return Logger.getLogger("org.quattor.pan.call");
            }

            @Override
            public Level logLevel() {
                return Level.INFO;
            }
        }
        ,
        CALL{

            @Override
            public Logger logger() {
                return Logger.getLogger("org.quattor.pan.call");
            }
        }
        ,
        MEMORY{

            @Override
            public Logger logger() {
                return Logger.getLogger("org.quattor.pan.memory");
            }
        }
        ,
        ALL{

            @Override
            public Logger logger() {
                return Logger.getLogger("org.quattor.pan");
            }

            @Override
            public void activate() {
                this.logger().setLevel(this.logLevel());
                TASK.logger().setLevel(this.logLevel());
                CALL.logger().setLevel(this.logLevel());
                MEMORY.logger().setLevel(this.logLevel());
            }
        }
        ,
        NONE{

            @Override
            public Logger logger() {
                return Logger.getLogger("org.quattor.pan");
            }

            @Override
            Level logLevel() {
                return Level.OFF;
            }

            @Override
            public void activate() {
                this.logger().setLevel(this.logLevel());
                TASK.logger().setLevel(this.logLevel());
                CALL.logger().setLevel(this.logLevel());
                MEMORY.logger().setLevel(this.logLevel());
            }
        };


        public abstract Logger logger();

        Level logLevel() {
            return Level.ALL;
        }

        public void activate() {
            this.logger().setLevel(this.logLevel());
        }
    }
}

