/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.ant;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.quattor.ant.DependencyChecker;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.CompilerResults;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.repository.SourceType;

public class PanCompilerTask
extends Task {
    private LinkedList<File> objectFiles = new LinkedList();
    private File includeroot = null;
    private List<DirSet> includes = new LinkedList<DirSet>();
    private LinkedList<File> includeDirectories = new LinkedList();
    private Pattern debugNsInclude = null;
    private Pattern debugNsExclude = null;
    private boolean debugTask = false;
    private boolean debugVerbose = false;
    private Pattern ignoreDependencyPattern = null;
    private boolean checkDependencies = true;
    private boolean verbose = false;
    private int deprecationLevel = 0;
    private boolean failOnWarn = false;
    protected static final String debugIndent = "    ";
    private String logging = "none";
    private File logFile = null;
    private int batchSize = 0;
    private int nthread = 0;
    private int maxIteration = 10000;
    private int maxRecursion = 50;
    private File outputDir = null;
    private Set<Formatter> formatters;
    private String initialData;
    private CompilerOptions.DeprecationWarnings deprecationWarnings = null;

    public PanCompilerTask() {
        this.setFormats("pan,dep");
    }

    public void execute() throws BuildException {
        if (this.includes.size() > 0) {
            if (this.includeroot == null) {
                throw new BuildException("includeroot must be specified to use 'includes' parameter");
            }
            Path antpath = new Path(this.getProject());
            for (DirSet dirset : this.includes) {
                dirset.setDir(this.includeroot);
                antpath.addDirset(dirset);
            }
            this.addPaths(antpath);
        }
        if (this.deprecationWarnings == null) {
            this.deprecationWarnings = CompilerOptions.getDeprecationWarnings(this.deprecationLevel, this.failOnWarn);
        }
        CompilerOptions options = null;
        try {
            options = new CompilerOptions(this.debugNsInclude, this.debugNsExclude, this.maxIteration, this.maxRecursion, this.formatters, this.outputDir, this.includeDirectories, this.deprecationWarnings, null, null, this.initialData, this.nthread);
        }
        catch (SyntaxException e2) {
            throw new BuildException("invalid root element: " + e2.getMessage());
        }
        if (this.debugTask) {
            System.err.println(options);
        }
        if (this.debugVerbose) {
            System.err.println("includeroot: " + this.includeroot);
            System.err.println("Profiles to process : \n");
            for (File objectFile : this.objectFiles) {
                System.err.println(debugIndent + objectFile + "\n");
            }
        }
        List<File> outdatedFiles = this.objectFiles;
        if (this.outputDir != null && this.checkDependencies) {
            DependencyChecker checker = new DependencyChecker(this.includeDirectories, this.outputDir, this.formatters, this.ignoreDependencyPattern);
            outdatedFiles = checker.filterForOutdatedFiles(this.objectFiles);
            if (this.debugVerbose) {
                System.err.println("Outdated profiles: \n");
                for (File objectFile : outdatedFiles) {
                    System.err.println(debugIndent + objectFile + "\n");
                }
            }
        }
        if (this.verbose) {
            System.out.println(outdatedFiles.size() + "/" + this.objectFiles.size() + " template(s) being processed");
        }
        CompilerLogging.activateLoggers(this.logging);
        CompilerLogging.setLogFile(this.logFile);
        List<List<File>> batches = this.batchOutdatedFiles(outdatedFiles);
        boolean hadError = false;
        for (List<File> batch : batches) {
            CompilerResults results = Compiler.run(options, null, batch);
            boolean batchHadError = results.print(this.verbose);
            if (!batchHadError) continue;
            hadError = true;
        }
        if (hadError) {
            throw new BuildException("Compilation failed; see messages.");
        }
    }

    public void setIncludeRoot(File includeroot) {
        this.includeroot = includeroot;
        if (!includeroot.exists()) {
            throw new BuildException("includeroot doesn't exist: " + includeroot);
        }
        if (!includeroot.isDirectory()) {
            throw new BuildException("includeroot must be a directory: " + includeroot);
        }
    }

    public void setIncludes(String includes) {
        String[] globs;
        for (String glob : globs = includes.split("[\\s,]+")) {
            DirSet dirset = new DirSet();
            dirset.setIncludes(glob);
            this.includes.add(dirset);
        }
    }

    public void addConfiguredPath(Path path2) {
        if (path2 != null) {
            this.addPaths(path2);
        }
    }

    private void addPaths(Path p) {
        for (String d : p.list()) {
            File dir2 = new File(d);
            if (!dir2.exists() || !dir2.isDirectory() || this.includeDirectories.contains(dir2)) continue;
            this.includeDirectories.add(dir2);
        }
    }

    public void addConfiguredFileSet(FileSet fileset) {
        this.addFiles(fileset);
    }

    private void addFiles(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        File basedir = ds.getBasedir();
        for (String f : ds.getIncludedFiles()) {
            if (!SourceType.hasSourceFileExtension(f)) continue;
            this.objectFiles.add(new File(basedir, f));
        }
    }

    public void setDebugTask(int debugTask) {
        this.debugTask = debugTask != 0;
        this.debugVerbose = debugTask > 1;
    }

    public void setDebugNsInclude(String pattern) {
        this.debugNsInclude = Pattern.compile(pattern);
    }

    public void setDebugNsExclude(String pattern) {
        this.debugNsExclude = Pattern.compile(pattern);
    }

    public void setInitialData(String initialData) {
        this.initialData = initialData;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setFormats(String fmts) {
        this.formatters = CompilerOptions.getFormatters(fmts);
    }

    public void setMaxIteration(int maxIteration) {
        this.maxIteration = maxIteration;
    }

    public void setMaxRecursion(int maxRecursion) {
        this.maxRecursion = maxRecursion;
    }

    public void setLogging(String loggingFlags) {
        this.logging = loggingFlags;
    }

    public void setLogfile(File logFile) {
        this.logFile = logFile;
    }

    public void setWarnings(String warnings) {
        try {
            this.deprecationWarnings = CompilerOptions.DeprecationWarnings.fromString(warnings);
        }
        catch (IllegalArgumentException e2) {
            throw new BuildException("invalid value for warnings: " + warnings);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setCheckDependencies(boolean checkDependencies) {
        this.checkDependencies = checkDependencies;
    }

    public void setIgnoreDependencyPattern(String ignoreDependencyPattern) {
        try {
            Pattern pattern;
            this.ignoreDependencyPattern = pattern = Pattern.compile(ignoreDependencyPattern);
        }
        catch (PatternSyntaxException e2) {
            throw new BuildException("invalid ignore dependency pattern: " + e2.getMessage());
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize > 0 ? batchSize : 0;
    }

    public int getNthread() {
        return this.nthread;
    }

    public void setNthread(int nthread) {
        this.nthread = nthread > 0 ? nthread : 0;
    }

    private List<List<File>> batchOutdatedFiles(List<File> outdatedFiles) {
        LinkedList<List<File>> batches = new LinkedList<List<File>>();
        int total = outdatedFiles.size();
        int myBatchSize = this.batchSize <= 0 ? outdatedFiles.size() : this.batchSize;
        for (int start = 0; start < total; start += myBatchSize) {
            int end = Math.min(start + myBatchSize, total);
            batches.add(outdatedFiles.subList(start, end));
        }
        return batches;
    }
}

