/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.ant;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.output.DepFormatter;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.parser.ASTTemplate;
import org.quattor.pan.repository.SourceType;
import org.quattor.pan.tasks.CompileTask;
import org.quattor.pan.utils.FileStatCache;
import org.quattor.pan.utils.FileUtils;

public class DependencyChecker {
    private final List<File> includeDirectories;
    private final Pattern ignoreDependencyPattern;
    private final FileStatCache statCache = new FileStatCache();
    private static final Pattern NONE = Pattern.compile("^$");
    private final Set<Formatter> formatters;
    private final CompilerOptions options = CompilerOptions.createCheckSyntaxOptions(CompilerOptions.DeprecationWarnings.OFF);
    private final URI outputDirectoryURI;
    private final Formatter depFormatter = DepFormatter.getInstance();

    public DependencyChecker(List<File> includeDirectories, File outputDirectory, Set<Formatter> formatters, Pattern ignoredDependencyPattern) {
        File file2;
        String userDir;
        ArrayList<File> dirs = new ArrayList<File>();
        if (includeDirectories != null) {
            dirs.addAll(includeDirectories);
        } else {
            userDir = System.getProperty("user.dir");
            file2 = new File(userDir).getAbsoluteFile();
            dirs.add(file2);
        }
        dirs.trimToSize();
        this.includeDirectories = Collections.unmodifiableList(dirs);
        this.ignoreDependencyPattern = ignoredDependencyPattern != null ? ignoredDependencyPattern : NONE;
        this.formatters = DependencyChecker.addDepFormatter(formatters);
        if (outputDirectory == null) {
            userDir = System.getProperty("user.dir");
            file2 = new File(userDir).getAbsoluteFile();
            this.outputDirectoryURI = file2.toURI();
        } else {
            this.outputDirectoryURI = outputDirectory.toURI();
        }
    }

    public List<File> filterForOutdatedFiles(List<File> objectFiles) {
        LinkedList<File> outdated = new LinkedList<File>();
        for (File objectFile : objectFiles) {
            if (!this.isOutdated(objectFile)) continue;
            outdated.add(objectFile);
        }
        return outdated;
    }

    public boolean isOutdated(File objectFile) {
        String objectName = DependencyChecker.extractLocalizedTemplateName(objectFile, this.options);
        if (objectName == null) {
            return true;
        }
        List<File> outputFiles = DependencyChecker.resolveOutputFiles(objectName, this.outputDirectoryURI, this.formatters);
        for (File outputFile : outputFiles) {
            if (this.statCache.exists(outputFile)) continue;
            return true;
        }
        long targetTime = Long.MAX_VALUE;
        for (File outputFile : outputFiles) {
            long t = this.statCache.getModificationTime(outputFile);
            if (t >= targetTime) continue;
            targetTime = t;
        }
        File depFile = DependencyChecker.resolveOutputFile(objectName, this.outputDirectoryURI, this.depFormatter);
        if (this.statCache.isMissingOrModifiedBefore(depFile, targetTime)) {
            return true;
        }
        return this.isDependencyListOutdated(depFile, targetTime);
    }

    public static String extractLocalizedTemplateName(File sourceFile, CompilerOptions options) {
        try {
            ASTTemplate ast2 = CompileTask.CallImpl.compile(sourceFile, options);
            String name2 = ast2.getIdentifier();
            return FileUtils.localizeFilename(name2);
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDependencyListOutdated(File dependencyFile, Long targetTime) {
        boolean outdated = false;
        Scanner scanner = null;
        try {
            scanner = new Scanner(dependencyFile);
            while (scanner.hasNextLine() && !outdated) {
                if (!this.isDependencyOutdated(scanner.nextLine(), targetTime)) continue;
                outdated = true;
                break;
            }
        }
        catch (IllegalArgumentException e2) {
            System.err.println("Warning: Outdated dependency file (" + dependencyFile.toString() + "); compiling profile");
            outdated = true;
        }
        catch (IOException e3) {
            outdated = true;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return outdated;
    }

    public boolean isDependencyOutdated(String line, Long targetTime) {
        DependencyInfo info = new DependencyInfo(line);
        if (this.ignoreDependencyPattern.matcher(info.name).matches()) {
            return false;
        }
        switch (info.type) {
            case TPL: {
                return this.isSourceDependencyOutdated(info, targetTime);
            }
            case PAN: {
                return this.isSourceDependencyOutdated(info, targetTime);
            }
            case TEXT: {
                return this.isTextDependencyOutdated(info, targetTime);
            }
            case ABSENT_SOURCE: {
                return this.lookupSourceFile(info.name) != null;
            }
            case ABSENT_TEXT: {
                return this.lookupTextFile(info.name) != null;
            }
        }
        throw new BuildException("unknown file type: " + (Object)((Object)info.type));
    }

    public boolean isSourceDependencyOutdated(DependencyInfo info, long targetTime) {
        if (this.isSingleDependencyOutdated(info.file, targetTime)) {
            return true;
        }
        File foundFile = this.lookupSourceFile(info.name);
        return DependencyChecker.isSingleDependencyDifferent(info.file, foundFile);
    }

    public boolean isTextDependencyOutdated(DependencyInfo info, long targetTime) {
        if (this.isSingleDependencyOutdated(info.file, targetTime)) {
            return true;
        }
        File foundFile = this.lookupTextFile(info.name);
        return DependencyChecker.isSingleDependencyDifferent(info.file, foundFile);
    }

    public boolean isSingleDependencyOutdated(File dep, long targetTime) {
        if (dep != null) {
            return this.statCache.isMissingOrModifiedAfter(dep, targetTime);
        }
        return true;
    }

    public File lookupSourceFile(String tplName) {
        String localTplName = FileUtils.localizeFilename(tplName);
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (String extension : SourceType.getExtensions()) {
            sourceFiles.add(localTplName + extension);
        }
        for (File pathdir : this.includeDirectories) {
            for (String sourceFile : sourceFiles) {
                File check2 = new File(pathdir, sourceFile);
                if (!this.statCache.exists(check2)) continue;
                return check2;
            }
        }
        return null;
    }

    public File lookupTextFile(String tplName) {
        String localTplName = FileUtils.localizeFilename(tplName);
        for (File pathdir : this.includeDirectories) {
            File check2 = new File(pathdir, localTplName);
            if (!this.statCache.exists(check2)) continue;
            return check2;
        }
        return null;
    }

    public static Set<Formatter> addDepFormatter(Set<Formatter> formatters) {
        boolean mustIncludeDepFormatter = true;
        HashSet<Formatter> f = new HashSet<Formatter>();
        f.addAll(formatters);
        for (Formatter formatter2 : formatters) {
            if (!(formatter2 instanceof DepFormatter)) continue;
            mustIncludeDepFormatter = false;
        }
        if (mustIncludeDepFormatter) {
            f.add(DepFormatter.getInstance());
        }
        return Collections.unmodifiableSet(f);
    }

    public static File resolveOutputFile(String objectName, URI uri, Formatter formatter2) {
        URI outputURI = uri.resolve(formatter2.getResultURI(objectName));
        return new File(outputURI);
    }

    public static List<File> resolveOutputFiles(String objectName, URI uri, Set<Formatter> formatters) {
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (Formatter f : formatters) {
            outputFiles.add(DependencyChecker.resolveOutputFile(objectName, uri, f));
        }
        return outputFiles;
    }

    public static boolean isSingleDependencyDifferent(File dep, File foundFile) {
        if (foundFile != null) {
            return !dep.equals(foundFile);
        }
        return false;
    }

    public static String stripPanExtensions(String name2) {
        for (SourceType type2 : SourceType.values()) {
            String extension = type2.getExtension();
            if ("".equals(extension) || !name2.endsWith(extension)) continue;
            int index2 = name2.lastIndexOf(extension);
            return name2.substring(0, index2);
        }
        return name2;
    }

    public static File reconstructSingleDependency(String templatePath, String tplName, SourceType type2) throws URISyntaxException {
        URI path2 = new URI(templatePath);
        URI fullname = new URI(tplName + type2.getExtension());
        URI fullpath = path2.resolve(fullname);
        return new File(fullpath).getAbsoluteFile();
    }

    public static class DependencyInfo {
        public final String name;
        public final SourceType type;
        public final File file;

        public DependencyInfo(String dependencyLine) {
            String[] fields = dependencyLine.split("\\s+");
            if (fields.length != 2 && fields.length != 3) {
                throw new BuildException("malformed dependency line");
            }
            this.name = fields[0];
            this.type = SourceType.valueOf(fields[1]);
            if (fields.length == 3) {
                try {
                    this.file = DependencyChecker.reconstructSingleDependency(fields[2], this.name, this.type);
                }
                catch (URISyntaxException e2) {
                    throw new BuildException(e2.getMessage());
                }
            } else {
                this.file = null;
            }
            this.validate();
        }

        private void validate() {
            if (this.file == null && !this.type.isAbsent()) {
                throw new BuildException("missing path information for dependency");
            }
            if (this.file != null && this.type.isAbsent()) {
                throw new BuildException("path information for absent file");
            }
        }
    }
}

