/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime.linux;

import org.qbicc.runtime.CNative;
import org.qbicc.runtime.posix.SysTypes;
import org.qbicc.runtime.stdc.Stddef;
import org.qbicc.runtime.stdc.Stdlib;
import org.qbicc.runtime.stdc.String;

@CNative.include(value="<sched.h>")
@CNative.define(value="_GNU_SOURCE")
public class Sched {
    public static native CNative.c_int sched_setaffinity(SysTypes.pid_t var0, Stddef.size_t var1, const_cpu_set_t_ptr var2);

    public static native CNative.c_int sched_getaffinity(SysTypes.pid_t var0, Stddef.size_t var1, cpu_set_t_ptr var2);

    public static void CPU_ZERO(cpu_set_t_ptr set) {
        Sched.CPU_ZERO_S(CNative.sizeof(cpu_set_t.class), set);
    }

    public static void CPU_ZERO_S(Stddef.size_t setSize, cpu_set_t_ptr set) {
        String.memset((CNative.void_ptr)((CNative.void_ptr)set.cast()), (CNative.c_int)((CNative.c_int)CNative.zero()), (Stddef.size_t)setSize);
    }

    public static void CPU_SET(int cpu, cpu_set_t_ptr set) {
        Sched.CPU_SET_S(CNative.sizeof(cpu_set_t.class), cpu, set);
    }

    public static void CPU_SET_S(Stddef.size_t size, int cpu, cpu_set_t_ptr set) {
        CNative.ptr<__cpu_mask> ptr2 = Sched.getMaskPtr(size, cpu, set);
        if (ptr2 != null) {
            ptr2.storeUnshared((Object)((__cpu_mask)CNative.word((long)(((__cpu_mask)((Object)ptr2.loadUnshared())).longValue() | 1L << Sched.getBitIdx(cpu)))));
        }
    }

    public static void CPU_CLR(int cpu, cpu_set_t_ptr set) {
        Sched.CPU_CLR_S(CNative.sizeof(cpu_set_t.class), cpu, set);
    }

    public static void CPU_CLR_S(Stddef.size_t size, int cpu, cpu_set_t_ptr set) {
        CNative.ptr<__cpu_mask> ptr2 = Sched.getMaskPtr(size, cpu, set);
        if (ptr2 != null) {
            ptr2.storeUnshared((Object)((__cpu_mask)CNative.word((long)(((__cpu_mask)((Object)ptr2.loadUnshared())).longValue() & 1L << Sched.getBitIdx(cpu)))));
        }
    }

    public static boolean CPU_ISSET(int cpu, cpu_set_t_ptr set) {
        return Sched.CPU_ISSET_S(CNative.sizeof(cpu_set_t.class), cpu, set);
    }

    public static boolean CPU_ISSET_S(Stddef.size_t size, int cpu, cpu_set_t_ptr set) {
        CNative.ptr<__cpu_mask> ptr2 = Sched.getMaskPtr(size, cpu, set);
        return ptr2 != null && (((__cpu_mask)((Object)ptr2.loadUnshared())).longValue() & 1L << Sched.getBitIdx(cpu)) != 0L;
    }

    public static int CPU_COUNT(cpu_set_t_ptr set) {
        return Sched.CPU_COUNT_S(CNative.sizeof(cpu_set_t.class), set);
    }

    public static int CPU_COUNT_S(Stddef.size_t size, cpu_set_t_ptr set) {
        int total = 0;
        int i = 0;
        while ((long)i < size.longValue() / CNative.sizeof(__cpu_mask.class).longValue()) {
            total += Long.bitCount(((__cpu_mask)((Object)Sched.getMaskPtr(size, i, set).loadUnshared())).longValue());
            ++i;
        }
        return total;
    }

    public static void CPU_AND(cpu_set_t_ptr dest, cpu_set_t_ptr src1, cpu_set_t_ptr src2) {
        Sched.CPU_AND_S(CNative.sizeof(cpu_set_t.class), dest, src1, src2);
    }

    public static void CPU_AND_S(Stddef.size_t size, cpu_set_t_ptr dest, cpu_set_t_ptr src1, cpu_set_t_ptr src2) {
        int i = 0;
        while ((long)i < size.longValue() / CNative.sizeof(__cpu_mask.class).longValue()) {
            Sched.getMaskPtr(size, i, dest).storeUnshared((Object)((__cpu_mask)CNative.word((long)(((__cpu_mask)((Object)Sched.getMaskPtr(size, i, src1).loadUnshared())).longValue() & ((__cpu_mask)((Object)Sched.getMaskPtr(size, i, src2).loadUnshared())).longValue()))));
            ++i;
        }
    }

    public static void CPU_OS(cpu_set_t_ptr dest, cpu_set_t_ptr src1, cpu_set_t_ptr src2) {
        Sched.CPU_OS_S(CNative.sizeof(cpu_set_t.class), dest, src1, src2);
    }

    public static void CPU_OS_S(Stddef.size_t size, cpu_set_t_ptr dest, cpu_set_t_ptr src1, cpu_set_t_ptr src2) {
        int i = 0;
        while ((long)i < size.longValue() / CNative.sizeof(__cpu_mask.class).longValue()) {
            Sched.getMaskPtr(size, i, dest).storeUnshared((Object)((__cpu_mask)CNative.word((long)(((__cpu_mask)((Object)Sched.getMaskPtr(size, i, src1).loadUnshared())).longValue() & ((__cpu_mask)((Object)Sched.getMaskPtr(size, i, src2).loadUnshared())).longValue()))));
            ++i;
        }
    }

    public static void CPU_XOR(cpu_set_t_ptr dest, cpu_set_t_ptr src1, cpu_set_t_ptr src2) {
        Sched.CPU_XOR_S(CNative.sizeof(cpu_set_t.class), dest, src1, src2);
    }

    public static void CPU_XOR_S(Stddef.size_t size, cpu_set_t_ptr dest, cpu_set_t_ptr src1, cpu_set_t_ptr src2) {
        int i = 0;
        while ((long)i < size.longValue() / CNative.sizeof(__cpu_mask.class).longValue()) {
            Sched.getMaskPtr(size, i, dest).storeUnshared((Object)((__cpu_mask)CNative.word((long)(((__cpu_mask)((Object)Sched.getMaskPtr(size, i, src1).loadUnshared())).longValue() & ((__cpu_mask)((Object)Sched.getMaskPtr(size, i, src2).loadUnshared())).longValue()))));
            ++i;
        }
    }

    public static boolean CPU_EQUAL(cpu_set_t_ptr set1, cpu_set_t_ptr set2) {
        return Sched.CPU_EQUAL_S(CNative.sizeof(cpu_set_t.class), set1, set2);
    }

    public static boolean CPU_EQUAL_S(Stddef.size_t size, cpu_set_t_ptr set1, cpu_set_t_ptr set2) {
        return String.memcmp((CNative.const_void_ptr)((CNative.const_void_ptr)set1.cast()), (CNative.const_void_ptr)((CNative.const_void_ptr)set2.cast()), (Stddef.size_t)size).isZero();
    }

    public static Stddef.size_t CPU_ALLOC_SIZE(int numCpus) {
        return (Stddef.size_t)CNative.word((int)(numCpus / CNative.sizeof(__cpu_mask.class).intValue()));
    }

    public static cpu_set_t_ptr CPU_ALLOC(int numCpus) {
        return (cpu_set_t_ptr)Stdlib.malloc((Stddef.size_t)Sched.CPU_ALLOC_SIZE(numCpus));
    }

    public static void CPU_FREE(cpu_set_t_ptr set) {
        Stdlib.free((CNative.ptr)set);
    }

    private static CNative.ptr<__cpu_mask> getMaskPtr(Stddef.size_t size, int cpu, cpu_set_t_ptr set) {
        int wordIdx = Sched.getWordIdx(cpu);
        if (wordIdx < size.intValue()) {
            return CNative.addr_of((CNative.object)((cpu_set_t)((Object)set.sel())).__bits[wordIdx]);
        }
        throw new IllegalArgumentException("Invalid CPU index");
    }

    private static int getWordIdx(int cpu) {
        return cpu / CNative.sizeof(__cpu_mask.class).intValue();
    }

    private static int getBitIdx(int cpu) {
        return cpu % CNative.sizeof(__cpu_mask.class).intValue();
    }

    public static final class cpu_set_t
    extends CNative.object {
        __cpu_mask[] __bits;
    }

    public static final class cpu_set_t_ptr
    extends CNative.ptr<cpu_set_t> {
    }

    static final class __cpu_mask
    extends CNative.word {
        __cpu_mask() {
        }
    }

    public static final class const_cpu_set_t_ptr
    extends CNative.ptr<cpu_set_t> {
    }
}

